unit TextEditorU;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms, QDialogs,
  QTypes, QMenus, QStdCtrls;

type
  TfrmTextEditor = class(TForm)
    mnuMainMenu: TMainMenu;
    memText: TMemo;
    dlgOpen: TOpenDialog;
    dlgSave: TSaveDialog;
    mniFile: TMenuItem;
    mniNew: TMenuItem;
    mniOpen: TMenuItem;
    mniSave: TMenuItem;
    mniSeparator: TMenuItem;
    mniExit: TMenuItem;
    mniEdit: TMenuItem;
    mniCut: TMenuItem;
    mniCopy: TMenuItem;
    mniPaste: TMenuItem;
    mniHelp: TMenuItem;
    mniAbout: TMenuItem;
    procedure mniExitClick(Sender: TObject);
    procedure mniAboutClick(Sender: TObject);
    procedure mniCutClick(Sender: TObject);
    procedure mniCopyClick(Sender: TObject);
    procedure mniPasteClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure memTextChange(Sender: TObject);
    procedure mniSaveClick(Sender: TObject);
    procedure mniNewClick(Sender: TObject);
    procedure mniOpenClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Private declarations }
    FModified: Boolean;
    FFileName: WideString;
    procedure SetFileName(const FileName: WideString);
  public
    { Public declarations }
  end;

var
  frmTextEditor: TfrmTextEditor;

implementation

{$R *.xfm}

procedure TfrmTextEditor.mniExitClick(Sender: TObject);
begin
  Close
end;

procedure TfrmTextEditor.mniAboutClick(Sender: TObject);
begin
  ShowMessage('Text Editor Application')
end;

procedure TfrmTextEditor.mniCutClick(Sender: TObject);
begin
  memText.CutToClipboard
end;

procedure TfrmTextEditor.mniCopyClick(Sender: TObject);
begin
  memText.CopyToClipboard
end;

procedure TfrmTextEditor.mniPasteClick(Sender: TObject);
begin
  memText.PasteFromClipboard
end;

procedure TfrmTextEditor.SetFileName(const FileName: WideString);
begin
  FFileName := FileName;
  if Length(FFileName) = 0 then
    Caption := '<New File>'
  else
    Caption := FFileName
end;

procedure TfrmTextEditor.FormCreate(Sender: TObject);
begin
  //Get the form to say we have a new file to start with
  SetFileName('')
end;

procedure TfrmTextEditor.memTextChange(Sender: TObject);
begin
  FModified := True
end;

procedure TfrmTextEditor.mniSaveClick(Sender: TObject);
begin
  if Length(FFileName) = 0 then
    if dlgSave.Execute then
      SetFileName(dlgSave.FileName);
  if Length(FFileName) > 0 then
  begin
    memText.Lines.SaveToFile(FFileName);
    FModified := False
  end
end;

procedure TfrmTextEditor.mniNewClick(Sender: TObject);
begin
  if FModified then
    case MessageDlg('Save changes?', mtConfirmation, [mbYes, mbNo, mbCancel], 0) of
      mrYes:    mniSaveClick(mniSave);
      mrNo:     FModified := False;
      mrCancel: Exit;
    end;
  if not FModified then
  begin
    SetFileName('');
    memText.Clear;
    FModified := False
  end
end;

procedure TfrmTextEditor.mniOpenClick(Sender: TObject);
begin
  if dlgOpen.Execute then
  begin
    mniNewClick(mniNew);
    if not FModified then
    begin
      memText.Lines.LoadFromFile(dlgOpen.FileName);
      SetFileName(dlgOpen.FileName);
      FModified := False
    end
  end
end;

procedure TfrmTextEditor.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  mniNewClick(mniNew);
  if FModified then
    CanClose := False
end;

end.
