//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "RTTIUnit.h"
#include <TypInfo.hpp>
#include <Registry.hpp>
#include <alloc.h>

const NoDefault = 0x80000000;
//V3 TTypeKind ends in tkInterface
//V4 TTypeKind ends in tkDynArray
#if __BCPLUSPLUS__ < 0x540
  #define tkPropsWithDefault (System::Set<Typinfo::TTypeKind, tkUnknown, tkInterface> () \
    << tkInteger << tkChar << tkEnumeration << tkSet )
#else
  #define tkPropsWithDefault (System::Set<Typinfo::TTypeKind, tkUnknown, tkDynArray> () \
    << tkInteger << tkChar << tkEnumeration << tkSet )
#endif

//Note: Must remove this definition if v6, if it is fixed there
#pragma warn -dup
#define tkAny (System::Set<Typinfo::TTypeKind, tkUnknown, tkDynArray> () << tkUnknown \
  << tkInteger << tkChar << tkEnumeration << tkFloat << tkString << tkSet << tkClass \
  << tkMethod << tkWChar << tkLString << tkWString << tkVariant << tkArray << tkRecord \
  << tkInterface << tkInt64 << tkDynArray )

void SetDefaults(TObject *Obj)
{
  //Find out how many properties we'll be considering
  int Count = GetPropList((PTypeInfo)(Obj->ClassInfo()), tkPropsWithDefault, NULL);
  //Allocate memory to hold their RTTI data
  PPropList List = new PPropInfo[Count];
  try
  {
    //Get hold of the property list in our new buffer
    GetPropList((PTypeInfo)(Obj->ClassInfo()), tkPropsWithDefault, List);
    //Loop through all the selected properties
    for (int i = 0; i < Count; i++)
    #if __BCPLUSPLUS__ < 0x540
      //If there is supposed to be a default value...
      if ((*List[i])->Default != NoDefault)
        //...then jolly well set it
        SetOrdProp(Obj, *List[i], (*List[i])->Default);
    #else
      //If there is supposed to be a default value...
      if (List[i]->Default != NoDefault)
        //...then jolly well set it
        SetOrdProp(Obj, List[i], List[i]->Default);
    #endif
  }
  __finally
  {
    delete[] List;
  }
}

void CopyObject(TObject *ObjFrom, TObject *ObjTo)
{
  //Iterate thru all published fields and
  //properties of source copying them to target

  //Find out how many properties we'll be considering
  int Count = GetPropList((PTypeInfo)ObjFrom->ClassInfo(), tkAny, NULL);
  //Allocate memory to hold their RTTI data
  PPropList PropInfos = new PPropInfo[Count];
  try
  {
    //Get hold of the property list in our new buffer
    GetPropList((PTypeInfo)ObjFrom->ClassInfo(), tkAny, PropInfos);
    //Loop through all the selected properties
    for (int i = 0; i < Count; i++)
    {
    #if __BCPLUSPLUS__ < 0x540
      PPropInfo PropInfo = GetPropInfo((PTypeInfo)ObjTo->ClassInfo(), (*PropInfos)[i]->Name);
      //Check the general type of the property
      //and read/write it in an appropriate way
      switch ((*(*PropInfos)[i]->PropType)->Kind)
    #else
      PPropInfo PropInfo = GetPropInfo((PTypeInfo)ObjTo->ClassInfo(), PropInfos[i]->Name);
      //Check the general type of the property
      //and read/write it in an appropriate way
      switch ((*PropInfos[i]->PropType)->Kind)
    #endif
      {
        case tkClass:
        {
          //Ignore properties which are themselves objects
          break;
        }
        case tkInteger:;
        case tkChar:;
        case tkEnumeration:;
        case tkSet:;
        case tkWChar:
        {
        #if __BCPLUSPLUS__ < 0x540
          int OrdVal = GetOrdProp(ObjFrom, (*PropInfos)[i]);
        #else
          int OrdVal = GetOrdProp(ObjFrom, PropInfos[i]);
        #endif
          if (PropInfo)
            SetOrdProp(ObjTo, PropInfo, OrdVal);
          break;
        }
        case tkFloat:
        {
        #if __BCPLUSPLUS__ < 0x540
          double FloatVal = GetFloatProp(ObjFrom, (*PropInfos)[i]);
        #else
          double FloatVal = GetFloatProp(ObjFrom, PropInfos[i]);
        #endif
          if (PropInfo)
            SetFloatProp(ObjTo, PropInfo, FloatVal);
          break;
        }
        case tkWString:;
        case tkLString:;
        case tkString:
        {
          //Avoid copying "Name" - components must have unique names
        #if __BCPLUSPLUS__ < 0x540
          if (UpperCase((*PropInfos)[i]->Name) != "NAME")
          {
            String StrVal = GetStrProp(ObjFrom, (*PropInfos)[i]);
            if (PropInfo)
              SetStrProp(ObjTo, PropInfo, StrVal);
          }
        #else
          if (UpperCase(PropInfos[i]->Name) != "NAME")
          {
            String StrVal = GetStrProp(ObjFrom, PropInfos[i]);
            if (PropInfo)
              SetStrProp(ObjTo, PropInfo, StrVal);
          }
        #endif
          break;
        }
        case tkMethod:
        {
        #if __BCPLUSPLUS__ < 0x540
          TMethod MethodVal = GetMethodProp(ObjFrom, (*PropInfos)[i]);
        #else
          TMethod MethodVal = GetMethodProp(ObjFrom, PropInfos[i]);
        #endif
          if (PropInfo)
            SetMethodProp(ObjTo, PropInfo, MethodVal);
        }
      }
    }
  }
  __finally
  {
    delete[] PropInfos;
  }
}

TRegIniFile *Reg;
const String Section = "Property Values";

//---------------------------------------------------------------------------
void ReadProp(TObject *Obj, const String PropName)
{
  PPropInfo Prop =
    GetPropInfo((PTypeInfo)Obj->ClassInfo(), PropName);
  if (!Prop)
    throw Exception("Property %s not found in %s class",
      ARRAYOFCONST((PropName, Obj->ClassName())));
  //For each case, read a value from the registry, using
  //the current value as the default, then use that read
  //value to set the property
  switch ((*Prop->PropType)->Kind)
  {
    case tkWString:;
    case tkLString:;
    case tkString:
      SetStrProp(Obj, Prop,
        Reg->ReadString(Section, PropName, GetStrProp(Obj, Prop)));
      break;
    case tkInteger:;
    case tkChar:;
    case tkSet:;
    case tkWChar:;
      SetOrdProp(Obj, Prop,
        Reg->ReadInteger(Section, PropName, GetOrdProp(Obj, Prop)));
      break;
    case tkFloat:
      SetFloatProp(Obj, Prop, StrToFloat(
        Reg->ReadString(Section, PropName,
          FloatToStr(GetFloatProp(Obj, Prop)))));
      break;
    //Enums are written out as strings
    case tkEnumeration:
      SetOrdProp(Obj, Prop, GetEnumValue(
          *Prop->PropType, Reg->ReadString(Section, PropName,
            GetEnumName(*Prop->PropType, GetOrdProp(Obj, Prop)))));
  }
}

void ReadProps(TObject *Obj, const String *PropNames, const int PropNames_Size)
{
  for (int i = 0; i <= PropNames_Size; i++)
    ReadProp(Obj, PropNames[i]);
}

void WriteProp(TObject *Obj, const String PropName)
{
  PPropInfo Prop =
    GetPropInfo((PTypeInfo)Obj->ClassInfo(), PropName);
  if (!Prop)
    throw Exception("Property %s not found in %s class",
      ARRAYOFCONST((PropName, Obj->ClassName())));
  //For each case, write the property value to the registry
  switch ((*Prop->PropType)->Kind)
  {
    case tkWString:;
    case tkLString:;
    case tkString:
      Reg->WriteString(Section, PropName, GetStrProp(Obj, Prop));
      break;
    case tkInteger:;
    case tkChar:;
    case tkSet:;
    case tkWChar:;
      Reg->WriteInteger(Section, PropName, GetOrdProp(Obj, Prop));
      break;
    case tkFloat:
      Reg->WriteString(Section, PropName, FloatToStr(GetFloatProp(Obj, Prop)));
      break;
    //Enums are written out as strings
    case tkEnumeration:
      Reg->WriteString(Section, PropName,
        GetEnumName(*Prop->PropType, GetOrdProp(Obj, Prop)));
  }
}

void WriteProps(TObject *Obj, const String *PropNames, const int PropNames_Size)
{
  for (int i = 0; i <= PropNames_Size; i++)
    WriteProp(Obj, PropNames[i]);
}

void Initialization(void)
{
  Reg = new TRegIniFile("Software\\BLong\\Property Saver");
}
#pragma startup Initialization

void Finalization(void)
{
  delete Reg;
}
#pragma exit Finalization
#pragma package(smart_init)
