unit Handlesu;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DB, DBTables, StdCtrls, ExtCtrls, Grids, DBGrids;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Table1: TTable;
    DBGrid1: TDBGrid;
    DataSource1: TDataSource;
    Image1: TImage;
    Button7: TButton;
    Button8: TButton;
    Button9: TButton;
    ComboBox1: TComboBox;
    ListBox1: TListBox;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Table1AfterPost(DataSet: TDataset);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses
  DbiProcs, DbiTypes;

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
  FlashWindow(Handle, True)
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  R: TRect;
begin
  R := Rect(0, 0, Width, Height);
  InvertRect(Canvas.Handle, R)
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  { Should say Button3.Hide, but this shows }
  { access to the button's handle }
  ShowWindow((Sender as TButton).Handle, sw_Hide)
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  { This sort of code often goes in AfterPost }
  { handlers for Paradox & dBASE tables as is }
  { done below }
  dbiSaveChanges(Table1.Handle)
end;

procedure TForm1.Table1AfterPost(DataSet: TDataset);
begin
  dbiSaveChanges((DataSet as TTable).Handle)
end;

procedure TForm1.Button5Click(Sender: TObject);
var
  Buffer: array[0..DbiMaxPathLen] of Char;
begin
  DbiGetDirectory(Table1.Database.Handle, True,
    Buffer);
  Caption := 'DBDEMOS = ' + StrPas(Buffer)
end;

procedure TForm1.Button6Click(Sender: TObject);
begin
  { Would be better to write:

  Image1.Picture.Icon.Assign(Application.Icon)

  but still... It shows a point }
  Image1.Picture.Icon.Handle := Application.Icon.Handle
end;

procedure TForm1.Button7Click(Sender: TObject);
begin
  Font.Handle := CreateFont(-11, 0, 0, 0,
    fw_DontCare, 0, 0, 0, Ansi_CharSet,
    Out_Default_Precis, Clip_Default_Precis,
    Proof_Quality, Variable_Pitch or ff_DontCare,
    nil);
end;

procedure TForm1.Button8Click(Sender: TObject);
begin
  SendMessage(ComboBox1.Handle, cb_ShowDropDown, 1, 0);

  { Can avoid using handle with Perform method }
  { ComboBox1.Perform(cb_ShowDropDown, 1, 0); }

  { Can avoid API stuff completely with VCL support }
  { which admittedly is not documented in Delphi 1 }
  { ComboBox1.DroppedDown := True; }
end;

procedure TForm1.Button9Click(Sender: TObject);
begin
  { Again, Perform would be better here }
  SendMessage(ListBox1.Handle,
    lb_SetHorizontalExtent, 220, 0);
end;

end.
