unit ActionLoggerU;

interface

uses
  StdActns,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ActnList, ImgList, ComCtrls, ToolWin, Menus, Buttons, AppEvnts;

type
  TForm1 = class(TForm)
    edtEntry: TEdit;
    Label1: TLabel;
    lstEntries: TListBox;
    btnAddString: TBitBtn;
    ActionList: TActionList;
    ImageList: TImageList;
    actAddString: TAction;
    MainMenu: TMainMenu;
    File1: TMenuItem;
    AddString1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    PopupMenu: TPopupMenu;
    AddString2: TMenuItem;
    ToolBar1: TToolBar;
    ToolButton1: TToolButton;
    ApplicationEvents: TApplicationEvents;
    procedure actAddStringExecute(Sender: TObject);
    procedure actAddStringUpdate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ApplicationEventsActionExecute(Action: TBasicAction;
      var Handled: Boolean);
  private
    { Private declarations }
  public
    UserLevel: Byte;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.actAddStringExecute(Sender: TObject);
begin
  lstEntries.Items.Add( Trim( edtEntry.Text ) );
  //Give focus back to edit
  edtEntry.SetFocus;
  //Highlight edit's contents so it can be replaced by overtyping
  edtEntry.SelectAll;
end;

procedure TForm1.actAddStringUpdate(Sender: TObject);
begin
  (Sender as TAction).Enabled :=
    ( Length( Trim( edtEntry.Text ) ) > 0 ) and
    ( lstEntries.Items.IndexOf( Trim( edtEntry.Text ) ) = -1 )
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  //Sinulate basic user with very little access rights
  UserLevel := 0;
end;

procedure TForm1.ApplicationEventsActionExecute(Action: TBasicAction;
  var Handled: Boolean);
var
  ActionLogFile: TextFile;
  ActionLogFileName: String;
begin
  //Ignore THintActions
  if Action is THintAction then
    Exit;
  //Make log file name same as EXE but ending in LOG
  ActionLogFileName := Application.ExeName;
  Delete(ActionLogFileName, Length(ActionLogFileName) - 2, 3);
  ActionLogFileName := ActionLogFileName + 'LOG';
  //Open the file, either by creating or appending
  AssignFile(ActionLogFile, ActionLogFileName);
  if FileExists(ActionLogFileName) then
    Append(ActionLogFile)
  else
    Rewrite(ActionLogFile);
  try
    //Write details to log file
    WriteLn(ActionLogFile, Action.Name, ': ',
            Action.ClassName, ' ', DateTimeToStr(Now));
  finally
    CloseFile(ActionLogFile)
  end
end;

end.
