unit RestartSampleFormU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

function RestartDialog(hwndOwner: HWnd;
  lpstrReason: PChar; uFlags: UINT): Integer; stdcall;
external 'Shell32.Dll' index 59;

function RestartDialogW(hwndOwner: HWnd;
  lpstrReason: PWideChar; uFlags: UINT): Integer; stdcall;
external 'Shell32.Dll' index 59;

procedure TForm1.Button1Click(Sender: TObject);
begin
  RestartDialog(Handle, nil, ewx_ShutDown)
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  RestartDialog(Handle, nil, ew_RestartWindows)
end;

procedure TForm1.Button3Click(Sender: TObject);
const
  Msg = 'I have played with your registry!'#13#13;
begin
  if Win32Platform = VER_PLATFORM_WIN32_WINDOWS then
    RestartDialog(Handle, Msg, ew_RestartWindows)
  else
    RestartDialogW(Handle, Msg, ew_RestartWindows)
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  if Win32Platform = VER_PLATFORM_WIN32_WINDOWS then
    RestartDialog(Handle, '#I have played with your registry!'#13#13 +
      'Restart Windows 95?', ew_RestartWindows)
  else
    RestartDialogW(Handle, '#I have played with your registry!'#13#13 +
      'Restart Windows NT?', ew_RestartWindows)
end;

end.
