unit SelDirU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    btnVCLDialog: TButton;
    btnShellDialog: TButton;
    lblDir: TLabel;
    lblTrimDir: TLabel;
    procedure btnVCLDialogClick(Sender: TObject);
    procedure btnShellDialogClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses
  FileCtrl;

{$R *.DFM}

procedure TForm1.btnVCLDialogClick(Sender: TObject);
var
  Dir: String;
begin
  if SelectDirectory(Dir, [sdAllowCreate, sdPerformCreate, sdPrompt], 0) then
  begin
    lblDir.Caption := Dir;
    lblTrimDir.Caption := MinimizeName(Dir, Canvas, lblTrimDir.Width);
  end;
end;

procedure TForm1.btnShellDialogClick(Sender: TObject);
var
  Dir: String;
begin
  if SelectDirectory('Select a directory', '', Dir) then
  begin
    lblDir.Caption := Dir;
    lblTrimDir.Caption := MinimizeName(Dir, Canvas, lblTrimDir.Width);
  end;
end;

end.
