unit ComputerNameSelectorForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses
  ActiveX, ComObj, ShlObj;

function GetComputerName: String;
var
  BrowseInfo: TBrowseInfo;
  ItemIDList: PItemIDList;
  ComputerName: array[0..MAX_PATH] of Char;
  WindowList: Pointer;
  Success: Boolean;
  Malloc: IMalloc;
begin
  OleCheck(SHGetMalloc(Malloc));
  if Failed(SHGetSpecialFolderLocation(Application.Handle,
            CSIDL_NETWORK, ItemIDList)) then
    raise Exception.Create('Computer Name Dialog Not Supported');
  try
    FillChar(BrowseInfo, SizeOf(BrowseInfo), 0);
    BrowseInfo.hwndOwner := Application.Handle;
    BrowseInfo.pidlRoot := ItemIDList;
    BrowseInfo.pszDisplayName := ComputerName;
    BrowseInfo.lpszTitle := 'Select Remote Machine';
    BrowseInfo.ulFlags := BIF_BROWSEFORCOMPUTER;
    WindowList := DisableTaskWindows(0);
    try
      Success := SHBrowseForFolder(BrowseInfo) <> nil;
    finally
      EnableTaskWindows(WindowList);
    end;
    if Success then
      Result := ComputerName
    else
      Result := ''
  finally
    Malloc.Free(ItemIDList)
  end
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  ShowMessage(GetComputerName)
end;

end.
