unit FindWordU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
var
  WordWnd: HWnd;
begin
  WordWnd := FindWindow('OpusApp', nil);
  if WordWnd <> 0 then
  begin
    //Restore app if necessary
    if IsIconic(WordWnd) then
      SendMessage(WordWnd, wm_SysCommand, sc_Restore, 0);
    SetForegroundWindow(WordWnd)
  end
end;

function EnumWindowFunc(Wnd: HWnd; lParam: Longint): Bool; stdcall;
var
 Buf: array[0..255] of Char;
begin
  Result := True;
  if GetClassName(Wnd, Buf, SizeOf(Buf)) > 0 then
    if StrIComp(Buf, 'OpusApp') = 0 then
    begin
      HWnd(Pointer(lParam)^) := Wnd;
      Result := False;
    end
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  WordWnd: HWnd;
begin
  EnumWindows(@EnumWindowFunc, Integer(@WordWnd));
  if WordWnd <> 0 then
  begin
    //Restore app if necessary
    if IsIconic(WordWnd) then
      SendMessage(WordWnd, wm_SysCommand, sc_Restore, 0);
    SetForegroundWindow(WordWnd)
  end
end;

function EnumChildWindowFunc(Wnd: HWnd; lParam: Longint): Bool; stdcall;
var
 Buf: array[0..255] of Char;
begin
  Result := True;
  if GetClassName(Wnd, Buf, SizeOf(Buf)) > 0 then
    if StrIComp(Buf, '_Wwg') = 0 then
    begin
      HWnd(Pointer(lParam)^) := Wnd;
      Result := False;
    end
end;

procedure TForm1.Button3Click(Sender: TObject);
var
  WordWnd, WordEditorWnd: HWnd;
  Loop: Integer;
  Rect: TRect;
  Canvas: TCanvas;
begin
  WordWnd := FindWindow('OpusApp', nil);
  if WordWnd <> 0 then
  begin
    //Restore app if necessary
    if IsIconic(WordWnd) then
      SendMessage(WordWnd, wm_SysCommand, sc_Restore, 0);
    SetForegroundWindow(WordWnd);
    //Give Word chance to be brought foreground, or restore itself
    Sleep(250);
    //Locate editor
    EnumChildWindows(WordWnd, @EnumChildWindowFunc, Integer(@WordEditorWnd));
    if WordEditorWnd <> 0 then
    begin
      //Get editor co-ordinates
      Windows.GetClientRect(WordEditorWnd, Rect);
      //Change width/height to be right/bottom
      Rect.BottomRight := Point(Rect.Left + Rect.Right, Rect.Top + Rect.Bottom);
      //Turn client-relative co-ordinates into screen-relative co-ordinates
      Windows.ClientToScreen(WordEditorWnd, Rect.TopLeft);
      Windows.ClientToScreen(WordEditorWnd, Rect.BottomRight);
      //Set up canvas for whole desktop and flash the editor a few times
      Canvas := TCanvas.Create;
      try
        Canvas.Pen.Mode := pmNot;
        Canvas.Pen.Width := 5;
        Canvas.Handle := GetDC(HWnd_Desktop);
        try
          for Loop := 1 to 8 do
          begin
            Canvas.Polyline([Rect.TopLeft, Point(Rect.Right, Rect.Top),
                             Rect.BottomRight, Point(Rect.Left, Rect.Bottom),
                             Rect.TopLeft]);
            Sleep(100);
          end
        finally
          ReleaseDC(HWnd_Desktop, Canvas.Handle)
        end
      finally
        Canvas.Free
      end
    end
  end;
end;

end.
