unit HeapMonitorMemMgr;

interface

uses
  Forms;

var
  HeapMonitorMemCount: Integer = 0;
  HeapMonitorMemSize: Integer = 0;

procedure UpdateDisplay;

implementation

uses
  SysUtils;

procedure UpdateDisplay;
begin
  if Assigned(Application) and Assigned(Application.MainForm) then
  begin
    Application.MainForm.Caption := Format('%s [Blocks=%d Bytes=%d]',
      [Application.Title, HeapMonitorMemCount, HeapMonitorMemSize]);
  end;
end;

var
  RTLMemoryManager: TMemoryManager = ();

function HeapBlockSize(P: Pointer): Integer;
var
  HeapPrefixDWordAddress: Integer;
begin
  //Access heap block prefix info, which includes block size and flags
  HeapPrefixDWordAddress := Integer(P) - 4;
  //Strip low 2 bits off as they are used as flags
  Result := Integer(Pointer(HeapPrefixDWordAddress)^) and not 3;
end;

function HeapMonitorGetMem(Size: Integer): Pointer;
begin
  Result := RTLMemoryManager.GetMem(Size);
  Inc(HeapMonitorMemCount);
  Inc(HeapMonitorMemSize, HeapBlockSize(Result))
end;

function HeapMonitorFreeMem(P: Pointer): Integer;
begin
  Dec(HeapMonitorMemSize, HeapBlockSize(P));
  Dec(HeapMonitorMemCount);
  Result := RTLMemoryManager.FreeMem(P)
end;

function HeapMonitorReallocMem(P: Pointer; Size: Integer): Pointer;
begin
  Dec(HeapMonitorMemSize, HeapBlockSize(P));
  Result := RTLMemoryManager.ReallocMem(P, Size);
  Inc(HeapMonitorMemSize, HeapBlockSize(Result))
end;

const
  HeapMonitorMemoryManager: TMemoryManager = (
    GetMem: HeapMonitorGetMem;
    FreeMem: HeapMonitorFreeMem;
    ReallocMem: HeapMonitorReallocMem);

initialization
  if FindCmdLineSwitch('HM', ['-','/'], True) then
  begin
    GetMemoryManager(RTLMemoryManager);
    SetMemoryManager(HeapMonitorMemoryManager);
  end
end.
