unit HeapMonitorTimer;

interface

implementation

uses
  SysUtils, ExtCtrls, Forms;

type
  THeapMonitor = class(TObject)
  public
    Timer: TTimer;
    constructor Create;
    procedure TimerTick(Sender: TObject);
  end;

constructor THeapMonitor.Create;
begin
  inherited;
  Timer := TTimer.Create(Application);
  Timer.Interval := 100;
  Timer.OnTimer := TimerTick;
end;

procedure THeapMonitor.TimerTick(Sender: TObject);
begin
  if Assigned(Application) and Assigned(Application.MainForm) then
    Application.MainForm.Caption := Format('%s [Blocks=%d Bytes=%d]',
      [Application.Title, AllocMemCount, AllocMemSize])
end;

var
  HeapMonitor: THeapMonitor = nil;

initialization
  if FindCmdLineSwitch('HM', ['-','/'], True) then
    HeapMonitor := THeapMonitor.Create
finalization
  HeapMonitor.Free
end.
