unit LayeredWindowU;

{$ifdef Ver80} { Delphi 1.0x }
  {$define DelphiLessThan2}
  {$define DelphiLessThan3}
  {$define DelphiLessThan4}
  {$define DelphiLessThan5}
{$endif}
{$ifdef Ver90} { Delphi 2.0x }
  {$define DelphiLessThan3}
  {$define DelphiLessThan4}
  {$define DelphiLessThan5}
{$endif}
{$ifdef Ver93} { C++ Builder 1.0x }
  {$define DelphiLessThan3}
  {$define DelphiLessThan4}
  {$define DelphiLessThan5}
{$endif}
{$ifdef Ver100} { Delphi 3.0x }
  {$define DelphiLessThan4}
  {$define DelphiLessThan5}
{$endif}
{$ifdef Ver110} { C++ Builder 3.0x }
  {$define DelphiLessThan4}
  {$define DelphiLessThan5}
{$endif}
{$ifdef Ver120} { Delphi 4.0x }
  {$define DelphiLessThan5}
{$endif}
{$ifdef Ver125} { C++Builder 4.0x }
  {$define DelphiLessThan5}
{$endif}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Image1: TImage;
    procedure FormCreate(Sender: TObject);
  public
    procedure CreateParams(var Params: TCreateParams); override;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{$ifdef DelphiLessThan3}
type
  EWin32Error = class(Exception);

function Win32Check(RetVal: BOOL): BOOL;
begin
  if not RetVal then
    raise EWin32Error.Create(SysErrorMessage(GetLastError));
  Result := RetVal;
end;
{$endif}

const
  lwa_Alpha = 2;
  ws_Ex_Layered = $80000;

procedure SetTranslucentForm(Form: TForm);
type
  TSetLayeredWindowAttributesProc = function (Wnd: HWnd; crKey: ColorRef; bAlpha: Byte; dwGlags: DWord): Bool; stdcall;
const
  User32Handle: HModule = 0;
  SetLayeredWindowAttributes: TSetLayeredWindowAttributesProc = nil;
begin
  if User32Handle = 0 then
  begin
    //User32 will be in memory, so no need for LoadLibrary
    User32Handle := GetModuleHandle(User32);
    @SetLayeredWindowAttributes := GetProcAddress(User32Handle,
      'SetLayeredWindowAttributes');
  end;
  if @SetLayeredWindowAttributes <> nil then
    Win32Check(SetLayeredWindowAttributes(
      Form.Handle, 0, 128, lwa_Alpha))
end;

procedure TForm1.CreateParams(var Params: TCreateParams);
begin
  inherited;
  //Need to set layered extended attribute
  //This has no effect on platforms that do not understand it
  Params.ExStyle := Params.ExStyle or ws_Ex_Layered
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  SetTranslucentForm(Self)
end;

end.
