unit Win32VersionCheckU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    lblOS: TLabel;
    lblBuild: TLabel;
    lblVersion: TLabel;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

type
  TWin32Version = (wvUnknown, wvWin95, wvWin98, wvWinME, wvWinNT, wvWin2000);

function Win32Version: TWin32Version;
var
  VerNo, VerWin95, VerWinME: Integer;
begin
  Result := wvUnknown;
  VerNo := MakeLong(Win32MajorVersion, Win32MinorVersion);
  VerWin95 := MakeLong(4, 0);
  VerWinME := MakeLong(4, 90);
  if Win32Platform = VER_PLATFORM_WIN32_WINDOWS then
  begin
    if VerNo = VerWin95 then
      Result := wvWin95
    else
      if (VerNo > VerWin95) and (VerNo < VerWinME) then
        Result := wvWin98
      else
        if VerNo >= VerWinME then
          Result := wvWinME
  end
  else
    if Win32MajorVersion <= 4 then
      Result := wvWinNT
    else
      if Win32MajorVersion = 5 then
        Result := wvWin2000
end;

const
  Win32Versions: array[TWin32Version] of String =
    ('Unknown Win32 platform',
     'Windows 95',
     'Windows 98',
     'Windows Millennium Edition',
     'Windows NT',
     'Windows 2000');

procedure TForm1.FormCreate(Sender: TObject);
var
  WinVer: TWin32Version;
  WinBuild: Integer;
begin
  WinVer := Win32Version;
  lblOS.Caption := Win32Versions[WinVer];
  WinBuild := Win32BuildNumber and $FFFF; //Only use low 32 bits
  lblVersion.Caption := Format('Version %d.%d', [Win32MajorVersion, Win32MinorVersion]);
  if (WinVer = wvWin95) and (WinBuild > 1080) then
    lblOS.Caption := lblOS.Caption + ' OSR2 (OEM Service Release 2)';
  lblBuild.Caption := Format('Build %d', [Win32BuildNumber and $FFFF]);
  if Trim(Win32CSDVersion) <> '' then
    lblBuild.Caption := lblBuild.Caption + ': ' + Trim(Win32CSDVersion);
end;

end.
