unit DIIClientForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, CorbaObj;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Timer1: TTimer;
    procedure Form1Create(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
  public
    InfoFactory, InfoServer: TAny;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Form1Create(Sender: TObject);
begin
  InfoFactory := CorbaBind('IDL:Server/InformationFactory:1.0');
  InfoServer := InfoFactory.CreateInstance('Server');
  Label1.Caption := 'Object running on ' +
    InfoServer.WhichUser +
    '''s machine, which is called ' +
    InfoServer.WhichMachine;
  Timer1.Enabled := True
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  try
    Caption := DateTimeToStr(InfoServer.CurrentDateAndTime)
  except
    Caption := 'Information server' 
  end
end;

end.
