unit ServerImpl;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, ComObj, StdVcl,
  CorbaObj, Server_TLB;

type
  TInformation = class(TCorbaImplementation, IInformation)
  private
    { Private declarations }
  public
    constructor Create(Controller: IObject; AFactory: TCorbaFactory); override;
    destructor Destroy; override;
  protected
    function CurrentDateAndTime: TDateTime; safecall;
    function WhichMachine: WideString; safecall;
    function WhichUser: WideString; safecall;
  end;

implementation

uses
  CorbInit, Forms;

constructor TInformation.Create(Controller: IObject;
  AFactory: TCorbaFactory);
begin
  inherited;
  Application.MainForm.Tag := Application.MainForm.Tag + 1;
  Application.MainForm.Caption := Format('%d active connection(s)', [Application.MainForm.Tag])
end;

destructor TInformation.Destroy;
begin
  Application.MainForm.Tag := Application.MainForm.Tag - 1;
  Application.MainForm.Caption := Format('%d active connection(s)', [Application.MainForm.Tag]);
  inherited;
end;

function TInformation.CurrentDateAndTime: TDateTime;
begin
  Result := Now
end;

function TInformation.WhichMachine: WideString;
var
  Buf: array[0..MAX_COMPUTERNAME_LENGTH] of Char;
  Len: DWord;
begin
  Len := SizeOf(Buf);
  if not GetComputerName(Buf, Len) then
    Result := SysErrorMessage(GetLastError)
  else
    Result := Buf
end;

function TInformation.WhichUser: WideString;
var
  Buf: array[0..255] of Char;
  Len: DWord;
begin
  Len := SizeOf(Buf);
  if not GetUserName(Buf, Len) then
    Result := SysErrorMessage(GetLastError)
  else
    Result := Buf
end;

initialization
  TCorbaObjectFactory.Create('InformationFactory', 'Information', 'IDL:Server/InformationFactory:1.0', IInformation,
    TInformation, iMultiInstance, tmSingleThread);
end.