unit Android.JNI.PowerManager;

interface

function AcquireWakeLock : Boolean;
procedure ReleaseWakeLock;

implementation

uses
  System.SysUtils,
  Androidapi.JNI,
  Androidapi.JNIBridge,
  Androidapi.JNI.GraphicsContentViewText,
  Androidapi.JNI.JavaTypes,
  FMX.Helpers.Android, Misc;

type
  JPowerManager = interface;
  JWakeLock = interface;

  JWakeLockClass = interface(JObjectClass)
  ['{918E171F-CDB8-4464-9507-F49272CE7636}']
  end;

  [JavaSignature('android/os/PowerManager$WakeLock')]
  JWakeLock = interface(JObject)
  ['{D17B1136-FA15-4AEB-85B1-2D490F0FD320}']
    {Methods}
    procedure acquire; cdecl;
    procedure release; cdecl;
    function isHeld: Boolean; cdecl;
  end;
  TJWakeLock = class(TJavaGenericImport<JWakeLockClass, JWakeLock>) end;

  JPowerManagerClass = interface(JObjectClass)
  ['{7D0696A2-ADEA-4158-AE1F-5E720DEDBCF9}']
    {Property methods}
    function _GetFULL_WAKE_LOCK: Integer; cdecl;
    function _GetSCREEN_BRIGHT_WAKE_LOCK: Integer; cdecl;
    function _GetSCREEN_DIM_WAKE_LOCK: Integer; cdecl;
    function _GetPARTIAL_WAKE_LOCK: Integer; cdecl;
    function _GetON_AFTER_RELEASE: Integer; cdecl;
    function _GetACQUIRE_CAUSES_WAKEUP: Integer; cdecl;
    {Properties}
    //Keep screen on bright & keyboard on
    //Deprecated in API level 17 - Jelly Bean MR1
    property FULL_WAKE_LOCK: Integer read _GetFULL_WAKE_LOCK;
    //Keep screen on bright
    //Deprecated in API level 13 - Honeycomb MR2
    property SCREEN_BRIGHT_WAKE_LOCK: Integer read _GetSCREEN_BRIGHT_WAKE_LOCK;
    //Keep screen on dim
    //Deprecated in API level 17 - Jelly Bean MR1
    property SCREEN_DIM_WAKE_LOCK: Integer read _GetSCREEN_DIM_WAKE_LOCK;
    //Keep CPU running, screen & keyboard can go off
    property PARTIAL_WAKE_LOCK: Integer read _GetPARTIAL_WAKE_LOCK;
    property ON_AFTER_RELEASE: Integer read _GetON_AFTER_RELEASE;
    property ACQUIRE_CAUSES_WAKEUP: Integer read _GetACQUIRE_CAUSES_WAKEUP;
  end;

  [JavaSignature('android/os/PowerManager')]
  JPowerManager = interface(JObject)
  ['{DEAED658-4353-4D17-B0A3-8179E48BE87F}']
    {Methods}
    function newWakeLock(levelAndFlags: Integer; tag: JString): JWakeLock; cdecl;
  end;
  TJPowerManager = class(TJavaGenericImport<JPowerManagerClass, JPowerManager>) end;

function GetPowerManager: JPowerManager;
var
  PowerServiceNative: JObject;
begin
  if not HasPermission('android.permission.WAKE_LOCK') then
    raise Exception.Create('You need the WAKE_LOCK permission');
  PowerServiceNative := SharedActivityContext.getSystemService(
    TJContext.JavaClass.POWER_SERVICE);
  if not Assigned(PowerServiceNative) then
    raise Exception.Create('Could not locate Power Service');
  Result := TJPowerManager.Wrap(
    (PowerServiceNative as ILocalObject).GetObjectID);
  if not Assigned(Result) then
    raise Exception.Create('Could not access Power Manager');
end;

var
  WakeLock: JWakeLock = nil;

function AcquireWakeLock: Boolean;
var
  PowerManager: JPowerManager;
begin
  Result := Assigned(WakeLock);
  if not Result then
  begin
    PowerManager := GetPowerManager;
    WakeLock := PowerManager.newWakeLock(
      TJPowerManager.JavaClass.SCREEN_BRIGHT_WAKE_LOCK or
      TJPowerManager.JavaClass.ON_AFTER_RELEASE,
      StringToJString('Delphi'));
    Result := Assigned(WakeLock);
  end;
  if Result then
  begin
    if not WakeLock.IsHeld then
    begin
      WakeLock.acquire;
      Result := WakeLock.isHeld
    end;
  end;
end;

procedure ReleaseWakeLock;
begin
  if Assigned(WakeLock) then
    WakeLock.release;
end;

end.
