unit BitmapStuff;

interface

uses
  FMX.Graphics,
  FMX.Forms,
  Androidapi.JNI.GraphicsContentViewText;

function JBitmapToBitmap(const AImage: JBitmap): TBitmap;

implementation

uses
  Androidapi.JNIBridge;

function JBitmapToBitmap(const AImage: JBitmap): TBitmap;
var
  ImageData: TJavaArray<Integer>;
  BitmapData: TBitmapData;
  Width, Height: Integer;
begin
  Assert(AImage <> nil);
  Width := AImage.getWidth;
  Height := AImage.getHeight;
  ImageData := TJavaArray<Integer>.Create(Width * Height);
  AImage.getPixels(ImageData, 0, Width, 0, 0, Width, Height);
  if Result.Map(TMapAccess.maWrite, BitmapData) then
  try
    Result := TBitmap.Create(Width, Height);
    Move(ImageData.Data^, BitmapData.Data^, Width * Height * SizeOf(Integer));
  finally
    Result.Unmap(BitmapData);
  end
  else
    Result := nil;
end;

end.
