unit Misc;

interface

function HasPermission(const Permission: string): Boolean;
procedure Vibrate(DurationMS: Int64);
procedure SendSMS(const Number, Msg: string);

procedure SetScreenOn(Value: Boolean);

implementation

uses
  System.UITypes,
  FMX.Dialogs,
  FMX.Helpers.Android,
  Androidapi.JNIBridge,
  Androidapi.JNI.App,
  Androidapi.JNI.OS,
  Androidapi.JNI.JavaTypes,
  Androidapi.JNI.GraphicsContentViewText,
  Androidapi.JNI.Telephony;

function HasPermission(const Permission: string): Boolean;
begin
  //Permissions listed at http://d.android.com/reference/android/Manifest.permission.html
  Result := SharedActivityContext.checkCallingOrSelfPermission(
    StringToJString(Permission)) =
    TJPackageManager.JavaClass.PERMISSION_GRANTED
end;

procedure Vibrate(DurationMS: Int64);
var
  VibratorObj: JObject;
  Vibrator: JVibrator;
begin
  if not HasPermission('android.permission.VIBRATE') then
    MessageDlg('App does not have the VIBRATE permission', TMsgDlgType.mtError, [TMsgDlgBtn.mbCancel], 0)
  else
  begin
    VibratorObj := SharedActivity.getSystemService(TJActivity.JavaClass.VIBRATOR_SERVICE);
    Vibrator := TJVibrator.Wrap((VibratorObj as ILocalObject).GetObjectID);
    Vibrator.vibrate(DurationMS);
  end;
end;

procedure SendSMS(const Number, Msg: string);
var
  SmsManager: JSmsManager;
begin
  if not HasPermission('android.permission.SEND_SMS') then
    MessageDlg('App does not have the SEND_SMS permission',
      TMsgDlgType.mtError, [TMsgDlgBtn.mbCancel], 0)
  else
  begin
    SmsManager := TJSmsManager.JavaClass.getDefault;
    SmsManager.sendTextMessage(
      StringToJString(Number),
      nil,
      StringToJString(Msg),
      nil,
      nil);
  end;
end;

//Set screen to stay on. No WAKE_LOCK permission required!
procedure SetScreenOn(Value: Boolean);
var
  Window: JWindow;
  ScreenOnFlag: Integer;
begin
  Window := SharedActivity.getWindow;
  ScreenOnFlag := TJWindowManager_LayoutParams.JavaClass.FLAG_KEEP_SCREEN_ON;
  CallInUIThread(procedure
  begin
    if Value then
      Window.setFlags(ScreenOnFlag, ScreenOnFlag)
    else
      Window.clearFlags(ScreenOnFlag)
  end);
end;

end.
