package com.blong.test;

import android.os.Bundle;
import android.util.Log;
import android.content.Intent;
import android.view.Menu;
import android.view.MenuItem;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.DialogInterface.OnClickListener;

public class NativeActivitySubclass extends com.embarcadero.firemonkey.FMXNativeActivity {

	static final String TAG = "NativeActivitySubclass";
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		//Custom initialization
		Log.d(TAG, "onCreate");
	}
	
	public native boolean onActivityResultNative(int requestCode, int resultCode, Intent data);
	
	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data){
		Log.d(TAG, "onActivityResult(" + requestCode + ", " + resultCode + ", " + (data != null ? data : "(null)") + ")");
		if (!onActivityResultNative(requestCode, resultCode, data))
			super.onActivityResult(requestCode, resultCode, data);
	}
	
	int get_resource_id(String resourceName)
	{
	return this.getResources().getIdentifier(resourceName, null,
		this.getPackageName()) ;
	}

@Override
	public boolean onCreateOptionsMenu(Menu menu)
	{
		Log.d(TAG, "onCreateOptionsMenu");
		getMenuInflater().inflate(get_resource_id("menu/main_menu"), menu);
		return super.onCreateOptionsMenu(menu);
	}
	
	public native boolean onOptionsItemSelectedNative(MenuItem item);
	
	@Override
	public boolean onOptionsItemSelected(MenuItem item)
	{
		Log.d(TAG, "onOptionsItemSelected");
		return onOptionsItemSelectedNative(item);
		//return super.onOptionsItemSelected(item);
	}
	
	public void showDialog(final String title, final String msg)
	{
		Log.d(TAG, "Displaying dialog");
		runOnUiThread(new Runnable() {
			public void run() {
				AlertDialog.Builder builder = new AlertDialog.Builder(NativeActivitySubclass.this);
				builder.setMessage(msg).
                        setTitle(title).
                        setCancelable(true).
                        setPositiveButton("OK", new OnClickListener(){
						public void onClick(DialogInterface dialog, int which)
						{
							dialog.dismiss();
						}
			      }).show();
			}
		});
	}

}
