unit LaunchIntents;

interface

procedure LaunchURL(const URL: string);

procedure ShowBatteryUsage;

procedure ShowTutorial;

procedure CreateEmail(const Recipient, Subject, Content: string);

procedure CreateSms(const Number, Msg: string);

procedure LaunchQRScanner;

implementation

uses
  System.SysUtils,
  FMX.Helpers.Android,
  Androidapi.JNIBridge,
  Androidapi.JNI.JavaTypes,
  Androidapi.JNI.GraphicsContentViewText,
  Androidapi.JNI.Net,
  Androidapi.JNI.Toast;

procedure LaunchURL(const URL: string);
var
  Intent: JIntent;
begin
  Intent := TJIntent.JavaClass.init(TJIntent.JavaClass.ACTION_VIEW,
    TJnet_Uri.JavaClass.parse(StringToJString(URL)));
  SharedActivity.startActivity(Intent);
end;

procedure ShowBatteryUsage;
var
  Intent: JIntent;
  ResolveInfo: JResolveInfo;
begin
  Intent := TJIntent.JavaClass.init(TJIntent.JavaClass.ACTION_POWER_USAGE_SUMMARY);
  ResolveInfo := SharedActivity.getPackageManager.resolveActivity(Intent, 0);
  if ResolveInfo = nil then
    Toast('Cannot display battery usage', ShortToast)
  else
    SharedActivity.startActivity(Intent);
end;

procedure ShowTutorial;
var
  Intent: JIntent;
  ResolveInfo: JResolveInfo;
begin
  Intent := TJIntent.JavaClass.init(TJIntent.JavaClass.ACTION_SYSTEM_TUTORIAL);
  ResolveInfo := SharedActivity.getPackageManager.resolveActivity(Intent, 0);
  if ResolveInfo = nil then
    Toast('Cannot display system tutorial', ShortToast)
  else
    SharedActivity.startActivity(Intent);
end;

procedure CreateEmail(const Recipient, Subject, Content: string);
var
  Intent: JIntent;
  Recipients: TJavaObjectArray<JString>;
begin
  Intent := TJIntent.JavaClass.init(TJIntent.JavaClass.ACTION_SEND);
  Recipients := TJavaObjectArray<JString>.Create(1);
  Recipients.Items[0] := StringToJString(Recipient);
  Intent.putExtra(TJIntent.JavaClass.EXTRA_EMAIL, Recipients);
  Intent.putExtra(TJIntent.JavaClass.EXTRA_SUBJECT, StringToJString(Subject));
  Intent.putExtra(TJIntent.JavaClass.EXTRA_TEXT, StringToJString(Content));
  //Intent.setType(StringToJString('plain/text'));
  Intent.setType(StringToJString('message/rfc822'));
  //SharedActivity.startActivity(Intent);
  SharedActivity.startActivity(TJIntent.JavaClass.createChooser(Intent,
    StrToJCharSequence('Which email app?')));
end;

procedure CreateSms(const Number, Msg: string);
var
  Intent: JIntent;
  Uri: Jnet_Uri;
begin
  Uri := TJnet_Uri.JavaClass.parse(StringToJString(Format('smsto:%s', [Number])));
  Intent := TJIntent.JavaClass.init(TJIntent.JavaClass.ACTION_VIEW, Uri);
  Intent.putExtra(StringToJString('sms_body'), StringToJString(Msg));
  SharedActivity.startActivity(Intent);
end;

//For more info see http://code.google.com/p/zxing/wiki/ScanningViaIntent
procedure LaunchQRScanner;
var
  Intent: JIntent;
  ResolveInfo: JResolveInfo;
begin
  Intent := TJIntent.JavaClass.init(StringToJString('com.google.zxing.client.android.SCAN'));
  Intent.setPackage(StringToJString('com.google.zxing.client.android'));
  Intent.putExtra(StringToJString('SCAN_MODE'), StringToJString('QR_CODE_MODE'));
  ResolveInfo := SharedActivity.getPackageManager.resolveActivity(Intent, 0);
  if ResolveInfo = nil then
    Toast('Cannot display QR scanner', ShortToast)
  else
    SharedActivity.startActivityForResult(Intent, 0);
end;

end.
