unit TestMainFormU;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Dialogs, FMX.StdCtrls, FMX.Edit,
  FMX.Layouts, FMX.Objects, FMX.ListBox;

type
  TMainForm = class(TForm)
    ListBox: TListBox;
    ListBoxGroupHeaderFMX: TListBoxGroupHeader;
    ListBoxItemMsgBox: TListBoxItem;
    ListBoxGroupHeaderAndroidAPI: TListBoxGroupHeader;
    ListBoxItemPermission: TListBoxItem;
    ListBoxItemVibrate: TListBoxItem;
    ListBoxItemURL: TListBoxItem;
    ListBoxItemMap: TListBoxItem;
    ListBoxItemStreetView: TListBoxItem;
    ListBoxItemToast: TListBoxItem;
    ListBoxItemBatteryUsage: TListBoxItem;
    ListBoxItemTutorial: TListBoxItem;
    ListBoxItemEmail: TListBoxItem;
    ListBoxItemSMS: TListBoxItem;
    StyleBookAndroidDark: TStyleBook;
    StyleBookAndroidLight: TStyleBook;
    ListBoxItemDarkStyle: TListBoxItem;
    ListBoxItemLightStyle: TListBoxItem;
    ListBoxItemWifi: TListBoxItem;
    ListBoxItemMobile: TListBoxItem;
    ListBoxItemNetworkConnected: TListBoxItem;
    ListBoxItemAcquireWakeLock: TListBoxItem;
    ListBoxItemReleaseWakeLock: TListBoxItem;
    ListBoxItemKeepScreenOn: TListBoxItem;
    ListBoxItemStopScreenOn: TListBoxItem;
    procedure ListBoxItemMsgBoxClick(Sender: TObject);
    procedure ListBoxItemPermissionClick(Sender: TObject);
    procedure ListBoxItemVibrateClick(Sender: TObject);
    procedure ListBoxItemURLClick(Sender: TObject);
    procedure ListBoxItemMapClick(Sender: TObject);
    procedure ListBoxItemStreetViewClick(Sender: TObject);
    procedure ListBoxItemToastClick(Sender: TObject);
    procedure ListBoxItemBatteryUsageClick(Sender: TObject);
    procedure ListBoxItemTutorialClick(Sender: TObject);
    procedure ListBoxItemEmailClick(Sender: TObject);
    procedure ListBoxItemSMSClick(Sender: TObject);
    procedure ListBoxItemLightStyleClick(Sender: TObject);
    procedure ListBoxItemDarkStyleClick(Sender: TObject);
    procedure ListBoxItemNetworkConnectedClick(Sender: TObject);
    procedure ListBoxItemWifiClick(Sender: TObject);
    procedure ListBoxItemMobileClick(Sender: TObject);
    procedure ListBoxItemAcquireWakeLockClick(Sender: TObject);
    procedure ListBoxItemReleaseWakeLockClick(Sender: TObject);
    procedure ListBoxItemKeepScreenOnClick(Sender: TObject);
    procedure ListBoxItemStopScreenOnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

uses
  Androidapi.JNIBridge,
  Androidapi.JNI.JavaTypes,
  FMX.Helpers.Android,
  FMX.Platform.Android,
  Androidapi.JNI.Toast,
  Android.JNI.PowerManager,
  LaunchIntents,
  Misc,
  BitmapStuff,
  Network;

{$R *.fmx}

procedure TMainForm.ListBoxItemAcquireWakeLockClick(Sender: TObject);
begin
  if not AcquireWakeLock then
    ShowMessage('Failed to acquire wake lock')
end;

procedure TMainForm.ListBoxItemBatteryUsageClick(Sender: TObject);
begin
  ShowBatteryUsage
end;

procedure TMainForm.ListBoxItemDarkStyleClick(Sender: TObject);
begin
  Stylebook := StyleBookAndroidDark
end;

procedure TMainForm.ListBoxItemEmailClick(Sender: TObject);
begin
  CreateEmail('test@test.com', 'Custom subject', 'Custom Content')
end;

procedure JNIDetachThread;
begin
end;

procedure TMainForm.ListBoxItemKeepScreenOnClick(Sender: TObject);
begin
  SetScreenOn(True);
end;

procedure TMainForm.ListBoxItemLightStyleClick(Sender: TObject);
begin
  StyleBook := StyleBookAndroidLight
end;

procedure TMainForm.ListBoxItemMapClick(Sender: TObject);
begin
  LaunchURL('geo:37.422,-122.084?z=17');
end;

procedure TMainForm.ListBoxItemMobileClick(Sender: TObject);
begin
  if IsMobileConnected then
    ShowMessage('Connected to the mobile network')
  else
    ShowMessage('Not connected to the mobile network')
end;

procedure TMainForm.ListBoxItemMsgBoxClick(Sender: TObject);
begin
  ShowMessage('O HAI!!!')
end;

procedure TMainForm.ListBoxItemNetworkConnectedClick(Sender: TObject);
begin
  if IsConnected then
    ShowMessage('Connected to the Internet')
  else
    ShowMessage('Not connected to the Internet')
end;

procedure TMainForm.ListBoxItemPermissionClick(Sender: TObject);
begin
  if HasPermission('android.permission.INTERNET') then
    ShowMessage('Permission granted')
  else
    ShowMessage('Permission denied')
end;

procedure TMainForm.ListBoxItemReleaseWakeLockClick(Sender: TObject);
begin
  ReleaseWakeLock
end;

procedure TMainForm.ListBoxItemSMSClick(Sender: TObject);
begin
  //SendSMS('07770663053', 'O HAI!')
  CreateSMS('07770663053', 'O HAI!')
end;

procedure TMainForm.ListBoxItemStopScreenOnClick(Sender: TObject);
begin
  SetScreenOn(False)
end;

procedure TMainForm.ListBoxItemStreetViewClick(Sender: TObject);
begin
  LaunchURL('google.streetview:cbll=37.422044,-122.083849&cbp=1,40,,0,1.0&mz=21');
end;

procedure TMainForm.ListBoxItemToastClick(Sender: TObject);
begin
	Toast('O HAI!!!', LongToast)
end;

procedure TMainForm.ListBoxItemTutorialClick(Sender: TObject);
begin
  ShowTutorial
end;

procedure TMainForm.ListBoxItemURLClick(Sender: TObject);
begin
  //See http://developer.android.com/guide/appendix/g-app-intents.html
  LaunchURL('http://flickr.com');
end;

procedure TMainForm.ListBoxItemVibrateClick(Sender: TObject);
begin
  Vibrate(1000);
end;

procedure TMainForm.ListBoxItemWifiClick(Sender: TObject);
begin
  if IsWiFiConnected then
    ShowMessage('Connected to Wi-Fi')
  else
    ShowMessage('Not connected to Wi-Fi')
end;

end.
