unit LaunchIntents;

interface

procedure LaunchQRScanner(RequestCode: Integer);

implementation

uses
  FMX.Types,
  FMX.Helpers.Android,
  Androidapi.JNI.JavaTypes,
  Androidapi.JNI.GraphicsContentViewText,
  Androidapi.JNI.Toast;

//For more info see http://code.google.com/p/zxing/wiki/ScanningViaIntent
procedure LaunchQRScanner(RequestCode: Integer);
var
  Intent: JIntent;
  ResolveInfo: JResolveInfo;
begin
  Log.d('LaunchQRScanner');
  Intent := TJIntent.JavaClass.init(StringToJString('com.google.zxing.client.android.SCAN'));
  Intent.setPackage(StringToJString('com.google.zxing.client.android'));
  //Intent.putExtra(StringToJString('SCAN_MODE'), StringToJString('QR_CODE_MODE'));
  Log.d('Checking intent resolution');
  ResolveInfo := SharedActivity.getPackageManager.resolveActivity(Intent, 0);
  if ResolveInfo = nil then
    Toast('Cannot display QR scanner', ShortToast)
  else
  begin
    Log.d('Starting QR scanner activity intent');
    SharedActivity.startActivityForResult(Intent, RequestCode);
  end;
end;

end.
