unit MainFormU;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs,
  Androidapi.JNI.GraphicsContentViewText, FMX.ListBox, FMX.Edit, FMX.StdCtrls,
  FMX.Layouts;

type
  TMainForm = class(TForm)
    StyleBookLight: TStyleBook;
    StyleBookDark: TStyleBook;
    ListBox1: TListBox;
    Layout1: TLayout;
    Button1: TButton;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Edit4: TEdit;
    ListBoxItem1: TListBoxItem;
    ListBoxItem2: TListBoxItem;
    ListBoxItem3: TListBoxItem;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    procedure RegisterDelphiNativeMethods;
    function GetResourceId(const ResourceName: string): Integer;
    function OnOptionsItemSelected(MenuItem: JMenuItem): Boolean;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

uses
  Posix.pthread,
  FMX.Helpers.Android,
  Androidapi.NativeActivity,
  Androidapi.JNI,
  Androidapi.JNIBridge,
  Androidapi.JNI.JavaTypes;

{$R *.fmx}

{$REGION 'JNI setup code and callback'}
var
  ARNMenuItem: JMenuItem;
  ARNResult: Boolean;

procedure OnOptionsItemSelectedThreadSwitcher;
begin
  Log.d('+OnOptionsItemSelectedThreadSwitcher');
  Log.d('Thread (Main: %.8x, Current: %.8x, Java:%.8d (%2:.8x), POSIX:%.8x)',
    [MainThreadID, TThread.CurrentThread.ThreadID, TJThread.JavaClass.currentThread.getId, GetCurrentThreadID]);
  ARNResult := MainForm.OnOptionsItemSelected(ARNMenuItem);
  Log.d('-OnOptionsItemSelectedThreadSwitcher');
end;

//This is called from the Java activity's onOptionsItemSelected() method
function OnOptionsItemSelectedNative(PEnv: PJNIEnv; This: JNIObject; JNIMenuItem: JNIObject): Boolean; cdecl;
begin
  Log.d('+OnOptionsItemSelectedNative');
  Log.d('Thread (Main: %.8x, Current: %.8x, Java:%.8d (%2:.8x), POSIX:%.8x)',
    [MainThreadID, TThread.CurrentThread.ThreadID, TJThread.JavaClass.currentThread.getId, GetCurrentThreadID]);
  ARNMenuItem := TJMenuItem.Wrap(JNIMenuItem);
  Log.d('Calling Synchronize');
  TThread.Synchronize(nil, OnOptionsItemSelectedThreadSwitcher);
  Log.d('Synchronize is over');
  Result := ARNResult;
  Log.d('-OnOptionsItemSelectedNative');
end;

procedure TMainForm.RegisterDelphiNativeMethods;
var
  PEnv: PJNIEnv;
  ActivityClass: JNIClass;
  NativeMethod: JNINativeMethod;
begin
  Log.d('Starting the registration JNI stuff');

  PEnv := TJNIResolver.GetJNIEnv;

  Log.d('Registering interop methods');

  NativeMethod.Name := 'onOptionsItemSelectedNative';
  NativeMethod.Signature := '(Landroid/view/MenuItem;)Z';
  NativeMethod.FnPtr := @OnOptionsItemSelectedNative;

  ActivityClass := PEnv^.GetObjectClass(
    PEnv, PANativeActivity(System.DelphiActivity).clazz);

  PEnv^.RegisterNatives(PEnv, ActivityClass, @NativeMethod, 1);

  PEnv^.DeleteLocalRef(PEnv, ActivityClass);
end;
{$ENDREGION}

{ TMainForm }

procedure TMainForm.FormCreate(Sender: TObject);
begin
  Log.d('TMainForm.FormCreate');
  RegisterDelphiNativeMethods
end;

procedure TMainForm.Button1Click(Sender: TObject);
begin
  ShowMessage('O HAI!')
end;

function TMainForm.GetResourceId(const ResourceName: string): Integer;
begin
  Result := SharedActivity.getResources.getIdentifier(
    StringToJString(ResourceName),
    nil,
    SharedActivity.getPackageName)
end;

function TMainForm.OnOptionsItemSelected(MenuItem: JMenuItem): Boolean;
begin
  Log.d('+TMainForm.OnOptionsItemSelected');
  Log.d('Thread (Main: %.8x, Current: %.8x, Java:%.8d (%2:.8x), POSIX:%.8x)',
    [MainThreadID, TThread.CurrentThread.ThreadID,
     TJThread.JavaClass.currentThread.getId, GetCurrentThreadID]);

  if MenuItem.getItemId = GetResourceId('id/menu_dark_theme') then
  begin
    Self.StyleBook := StyleBookDark;
    Result := True;
  end
  else
  if MenuItem.getItemId = GetResourceId('id/menu_light_theme') then
  begin
    Self.StyleBook := StyleBookLight;
    Result := True;
  end
  else
    Result := False;

  Log.d('-TMainForm.OnOptionsItemSelected');
end;

end.
