unit MainFormU;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs, FMX.ListBox,
  FMX.Layouts, FMX.StdCtrls;

type
  TMainForm = class(TForm)
    ListBox: TListBox;
    ListBoxItem1: TListBoxItem;
    ListBoxItem2: TListBoxItem;
    ListBoxItem3: TListBoxItem;
    ListBoxItem4: TListBoxItem;
    ListBoxItem5: TListBoxItem;
    ListBoxItem6: TListBoxItem;
    ListBoxItem7: TListBoxItem;
    ToolBar1: TToolBar;
    Label1: TLabel;
    ListBoxItem8: TListBoxItem;
    procedure ListBoxItem1Click(Sender: TObject);
    procedure ListBoxItem2Click(Sender: TObject);
    procedure ListBoxItem3Click(Sender: TObject);
    procedure ListBoxItem4Click(Sender: TObject);
    procedure ListBoxItem5Click(Sender: TObject);
    procedure ListBoxItem6Click(Sender: TObject);
    procedure ListBoxItem7Click(Sender: TObject);
    procedure ListBoxItem8Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

uses
  Macapi.ObjectiveC,
  iOSapi.CocoaTypes,
  iOSapi.Foundation,
  iOSapi.UIKit,
  FMX.Helpers.iOS;

{$R *.fmx}

{$REGION 'Using UIScreen'}
procedure TMainForm.ListBoxItem1Click(Sender: TObject);
var
  Screen: UIScreen;
  ScreenBounds: NSRect;
begin
  Screen := TUIScreen.Wrap(TUIScreen.OCClass.mainScreen);
  ScreenBounds := Screen.bounds;
  ShowMessageFmt(
    'Top-left = (%.0f,%.0f)'#10'Width = %.0f'#10'Height = %.0f',
    [ScreenBounds.origin.x, ScreenBounds.origin.y,
     ScreenBounds.size.width, ScreenBounds.size.height]);
end;

procedure TMainForm.ListBoxItem2Click(Sender: TObject);
var
  ScreenBounds: NSRect;
begin
  ScreenBounds := MainScreen.bounds;
  ShowMessageFmt(
    'Top-left = (%.0f,%.0f)'#10'Width = %.0f'#10'Height = %.0f',
    [ScreenBounds.origin.x, ScreenBounds.origin.y,
     ScreenBounds.size.width, ScreenBounds.size.height]);
end;
{$ENDREGION}

{$REGION 'Using UIDevice'}
procedure TMainForm.ListBoxItem3Click(Sender: TObject);
var
  Device: UIDevice;
  ModelNS: NSString;
begin
  Device := TUIDevice.Wrap(TUIDevice.OCClass.currentDevice);
  ModelNS := Device.model;
  NSLog((ModelNS as ILocalObject).GetObjectID);
  //Log.d(NSStrToStr(ModelNS));
  ShowMessage(NSStrToStr(ModelNS));
end;
{$ENDREGION}

{$REGION 'UIAlertView example 1'}
procedure TMainForm.ListBoxItem4Click(Sender: TObject);
var
  AlertView: UIAlertView;
begin
  AlertView := TUIAlertView.Create;
  try
    AlertView.setTitle(NSStr('Delphi for CocoaTouch'));
    AlertView.setMessage(NSStr('Hello CodeRage'));
    AlertView.setCancelButtonIndex(AlertView.addButtonWithTitle(NSStr('OK')));
    AlertView.show;
  finally
    AlertView.release;
  end;
end;
{$ENDREGION}

{$REGION 'UIAlertView example 2'}
procedure TMainForm.ListBoxItem5Click(Sender: TObject);
var
  alertView: UIAlertView;
begin
  alertView := TUIAlertView.Alloc;
  try
    alertView := TUIAlertView.Wrap(alertView.initWithTitle(
      NSStr('Delphi for CocoaTouch'), //title
      NSStr('Hello CodeRage'),        //message
      nil,                            //delegate
      NSStr('OK'),                    //cancel button caption
      nil));                          //other button captions
    alertView.show;
  finally
    alertView.release;
  end;
end;
{$ENDREGION}

{$REGION 'UIAlertView example 3'}
type
  TAlertViewDelegate = class(TOCLocal, UIAlertViewDelegate)
  public
    procedure alertView(alertView: UIAlertView; clickedButtonAtIndex: NSInteger); cdecl;
    procedure alertViewCancel(alertView: UIAlertView); cdecl;
  end;

var
  Delegate: UIAlertViewDelegate;

function PNSSTR(const Str: string): Pointer;
begin
  Result := (NSStr(Str) as ILocalObject).GetObjectID
end;

procedure TAlertViewDelegate.alertView(alertView: UIAlertView;
  clickedButtonAtIndex: NSInteger);
begin
  NSLog(PNSSTR('A button was pressed on the dialog!'));
  //Log.d('A button was pressed on the dialog!');
  case clickedButtonAtIndex of
    0: Log.d('You clicked Cancel');
    1: Log.d('You clicked Yes');
    2: Log.d('You clicked No');
    3: Log.d('You clicked Maybe');
  end;
  //Log.d(Format('Clicked button at index %d', [clickedButtonAtIndex]));
  alertView.setDelegate(nil);
  Delegate := nil;
end;

procedure TAlertViewDelegate.alertViewCancel(alertView: UIAlertView);
begin
  //NSLog(PNSStr('alertView cancelled'));
  Log.d('alertView cancelled');
  alertView.setDelegate(nil);
  Delegate := nil;
end;

procedure TMainForm.ListBoxItem6Click(Sender: TObject);
var
  AlertView: UIAlertView;
begin
  Delegate := TAlertViewDelegate.Create;
  AlertView := TUIAlertView.Alloc;
  try
    AlertView := TUIAlertView.Wrap(AlertView.initWithTitle(
      NSStr('Philosophical Question'),        //title
      NSStr('Is Schrdinger''s cat dead?'),   //message
      (Delegate as ILocalObject).GetObjectID, //delegate
      NSStr('Cancel'),                        //cancel button caption
      nil));                                  //other button captions
    AlertView.addButtonWithTitle(NSStr('Yes'));
    AlertView.addButtonWithTitle(NSStr('No'));
    AlertView.addButtonWithTitle(NSStr('Maybe'));
    AlertView.show;
  finally
    AlertView.release;
  end;
end;
{$ENDREGION}

{$REGION 'Network activity'}
procedure TMainForm.ListBoxItem7Click(Sender: TObject);
begin
  SharedApplication.setNetworkActivityIndicatorVisible(True);
end;

procedure TMainForm.ListBoxItem8Click(Sender: TObject);
begin
  SharedApplication.setNetworkActivityIndicatorVisible(False);
end;
{$ENDREGION}

end.
