unit HelloCocoaWorld.AppDelegate;

interface

uses
  iOSapi.Foundation,
  iOSapi.UIKit,
  Delphi.Platform.iOS,
  HelloCocoaWorld.RootViewController;

type
  THelloWorldApplicationDelegate = class(TApplicationDelegate)
  public
    Window: UIWindow;
    //This class-wide ref to the controller keeps the Pascal object alive
    RootViewController: TRootViewController;
    function application(const Sender: UIApplication;
      const didFinishLaunchingWithOptions: NSDictionary): Boolean; overload;
      override; cdecl;
    procedure applicationWillTerminate(const Sender: UIApplication); override; cdecl;
  end;

implementation

uses
  iOSapi.CoreGraphics;

{ THelloWorldApplicationDelegate }

function THelloWorldApplicationDelegate.application(const Sender: UIApplication;
  const didFinishLaunchingWithOptions: NSDictionary): Boolean;
var
  screenBounds: CGRect;
begin
  inherited;
  //Create window

  // window := UIWindow.alloc.initWithFrame(UIScreen.mainScreen.bounds);
  screenBounds := CocoaTouch.MainScreen.bounds;
  Window := TUIWindow.Wrap(TUIWindow.Alloc.initWithFrame(screenBounds));
  Window.setOpaque(True);

  //viewController := TUIViewController.Wrap(TUIViewController.Alloc.initWithNibName(nil, nil));
  RootViewController := TRootViewController.Create;
  Window.setRootViewController(RootViewController.viewController);
  Window.makeKeyAndVisible;
  Result := True
end;

procedure THelloWorldApplicationDelegate.applicationWillTerminate(
  const Sender: UIApplication);
begin
  RootViewController.viewController.release;
  Window.release;
end;

initialization
  ApplicationDelegateClass := THelloWorldApplicationDelegate
end.
