unit HelloCocoaWorld.RootViewController;

//{$DEFINE GLOBAL_CALLBACK}

interface

uses
  Delphi.Platform.iOS,
  iOSapi.UIKit;

type
  RootViewController = interface(UIViewController)
    ['{DF3D7366-B23E-4697-AC86-DE98346B5C3B}']
    procedure loadView; cdecl;
    procedure viewDidDisappear(animated: Boolean); cdecl;
  {$IFNDEF GLOBAL_CALLBACK}
    procedure buttonPressed(sender: id); cdecl;
  {$ENDIF}
  end;

  TRootViewController = class(TBaseUIViewController<RootViewController>)
  private
    &label: UILabel;
    button: UIButton;
  public
    constructor Create;
    procedure viewDidDisappear(animated: Boolean); cdecl;
    procedure loadView; cdecl;
  {$IFNDEF GLOBAL_CALLBACK}
    //Callbacks - make sure thy are public so the smart linker doesn't strip them away
    procedure buttonPressed(sender: id); cdecl;
  {$ENDIF}
  end;

implementation

uses
  Macapi.ObjCRuntime, System.Rtti, System.SysUtils,
  iOSapi.Foundation, iOSapi.CoreGraphics, iOSapi.Utils;

{ TRootViewController }

{$IFDEF GLOBAL_CALLBACK}
procedure buttonPressedG(self: id; _cmd: SEL; sender: id); cdecl;
var
  btn: UIButton;
begin
  NSLog(PNSSTR('Global button press response'));
  btn := TUIButton.Wrap(sender);
  btn.setTitle(NSStr('O HAI!'), UIControlStateNormal);
end;
{$ELSE}
procedure TRootViewController.buttonPressed(sender: id);
var
  btn: UIButton;
begin
  NSLog(PNSSTR('Local (instance-based) button press response'));
  btn := TUIButton.Wrap(sender);
  btn.setTitle(NSStr('O HAI!'), UIControlStateNormal);
end;
{$ENDIF}

constructor TRootViewController.Create;
var
  V: Pointer;
begin
  inherited;
  V := UIViewController(Super).initWithNibName(nil, nil);
  if GetObjectID <> V then
    UpdateObjectID(V);
end;

procedure TRootViewController.viewDidDisappear(animated: Boolean);
begin
  //Call inherited UIViewController method
  UIViewController(Super).viewDidDisappear(animated);
  &label.release;
  &label := nil;
  button.release;
  button := nil;
  view.release;
  view := nil;
end;

procedure TRootViewController.loadView;
var
  frame: CGRect;
  //We have to be careful not to try and read back from view
  //after setting it as on the device it crashes.....
  //So we'll just set it up all locally, assign it and be done
  theView: UIView;
begin
  //In the case of loadView we *don't* call the inherited method

  //Do custom setup

  //allocate the view
  //theView := UIView.alloc.init;
  //If using a custom init*** do like this
  //theView := TUIView.Wrap(TUIView.Alloc.init);
  //But for regular init, do like this
  //theView := TUIView.Create;
  //Except looking at the RTL code it looks like we should actually do this
  //This is backed up by the code above crashing
  theView := TUIView.Wrap(TUIView.Alloc.init);

  //Set the view's background color
  theView.setBackgroundColor(TUIColor.Wrap(TUIColor.OCClass.whiteColor));

  //set the position of the label
  frame := CGRectMake(50, 100, 200, 50);

  //allocate the label
  &label := TUILabel.Wrap(TUILabel.Alloc.initWithFrame(frame));

  //set the label's text
  &label.setText(NSSTR('Hello world - from Cocoa'));

  //add the label to the view
  theView.addSubview(&label);

  //create the button
  button := TUIButton.Wrap(TUIButton.OCClass.buttonWithType(UIButtonTypeRoundedRect));

  //set the position of the button
  button.setFrame(CGRectMake(100, 200, 100, 30));

  //set the button's title
  button.setTitle(NSSTR('Click Me!'), UIControlStateNormal);

  //listen for clicks
{$IFDEF GLOBAL_CALLBACK}
  class_addMethod(objc_getclass('RootViewController'),
    sel_getUid('buttonPressedG:'), @buttonPressedG, 'v@:@');
  button.addTarget(GetObjectID, sel_registerName('buttonPressedG:'),
    UIControlEventTouchUpInside);
{$ELSE}
  button.addTarget(GetObjectID,
    //sel_registerName('buttonPressed:'),
    SelectorForMethod(Self, 'buttonPressed'),
    UIControlEventTouchUpInside);
{$ENDIF}

  //add the button to the view
  theView.addSubview(button);

  view := theView;
end;

end.
