unit BrowserFormU;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Dialogs, FMX.WebBrowser, FMX.Layouts,
  FMX.Edit, FMX.StdCtrls;

type
  TBrowserForm = class(TForm)
    Header: TToolBar;
    HeaderLabel: TLabel;
    NavigateBackButton: TSpeedButton;
    BackHistoryButton: TButton;
    ForwardHistoryButton: TButton;
    UrlEdit: TEdit;
    FlowLayout1: TFlowLayout;
    WebBrowser: TWebBrowser;
    RefreshButton: TSpeedButton;
    procedure NavigateBackButtonClick(Sender: TObject);
    procedure WebBrowserDidStartLoad(ASender: TObject);
    procedure WebBrowserDidFinishLoad(ASender: TObject);
    procedure WebBrowserDidFailLoadWithError(ASender: TObject);
    procedure RefreshButtonClick(Sender: TObject);
    procedure BackHistoryButtonClick(Sender: TObject);
    procedure ForwardHistoryButtonClick(Sender: TObject);
    procedure UrlEditKeyDown(Sender: TObject; var Key: Word; var KeyChar: Char;
      Shift: TShiftState);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
    procedure LoadUrl(URL: String);
  public
    { Public declarations }
  end;

var
  BrowserForm: TBrowserForm;

implementation

uses
  FMX.Utils;

{$R *.fmx}

procedure TBrowserForm.LoadUrl(URL: String);
begin
  if Length(URL) > 0 then
  begin
    if not URL.StartsWith('http') then
      URL := 'http://' + URL;
    WebBrowser.URL := URL;
    Log(URL);
  end;
  UrlEdit.Text := URL;
end;

procedure TBrowserForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := TCloseAction.caFree
end;

procedure TBrowserForm.FormCreate(Sender: TObject);
begin
  LoadUrl('flickr.com');
end;

procedure TBrowserForm.FormDestroy(Sender: TObject);
begin
  SetNetworkActivityIndicatorVisible(False);
end;

procedure TBrowserForm.NavigateBackButtonClick(Sender: TObject);
begin
  Close
end;

procedure TBrowserForm.BackHistoryButtonClick(Sender: TObject);
begin
  WebBrowser.GoBack
end;

procedure TBrowserForm.ForwardHistoryButtonClick(Sender: TObject);
begin
  WebBrowser.GoForward
end;

procedure TBrowserForm.RefreshButtonClick(Sender: TObject);
begin
  WebBrowser.Navigate
end;

procedure TBrowserForm.UrlEditKeyDown(Sender: TObject; var Key: Word;
  var KeyChar: Char; Shift: TShiftState);
begin
  if Key = vkReturn then
  begin
    //Navigate and hide the virtual keyboard when setting focus to Refresh
    LoadURL(UrlEdit.Text);
    RefreshButton.SetFocus
  end;
end;

procedure TBrowserForm.WebBrowserDidStartLoad(ASender: TObject);
begin
  SetNetworkActivityIndicatorVisible(True);
end;

procedure TBrowserForm.WebBrowserDidFinishLoad(ASender: TObject);
begin
  //Show URL that eventually loaded
  //Oh, except that's only available through the UIWebView.request and we don't have that
  URLEdit.Text := WebBrowser.URL;
  SetNetworkActivityIndicatorVisible(False);
end;

procedure TBrowserForm.WebBrowserDidFailLoadWithError(ASender: TObject);
begin
  SetNetworkActivityIndicatorVisible(True);
  ShowMessage('Web page failed to load for an unknown reason');
end;

end.
