unit ListAppCocoa.AppDelegate;

interface

uses
  iOSapi.Foundation,
  iOSapi.UIKit,
  Delphi.Platform.iOS,
  ListAppCocoa.MasterViewController;

type
  TListApplicationDelegate = class(TApplicationDelegate)
  public
    Window: UIWindow;
    //This class-wide ref to the controller keeps the Pascal object alive
    MasterViewController: TMasterViewController;
    NavigationController: UINavigationController;
    function application(const Sender: UIApplication;
      const didFinishLaunchingWithOptions: NSDictionary): Boolean; overload;
      override; cdecl;
    procedure applicationWillTerminate(const Sender: UIApplication);
      override; cdecl;
  end;

implementation

uses
  iOSapi.CoreGraphics;

{ THelloWorldApplicationDelegate }

function TListApplicationDelegate.application(const Sender: UIApplication;
  const didFinishLaunchingWithOptions: NSDictionary): Boolean;
var
  screenBounds: CGRect;
begin
  inherited;

  //Create window

  screenBounds := CocoaTouch.MainScreen.bounds;
  Window := TUIWindow.Wrap(TUIWindow.Alloc.initWithFrame(screenBounds));
  //Window.setOpaque(True);

  //viewController := TUIViewController.Wrap(TUIViewController.Alloc.initWithNibName(nil, nil));
  MasterViewController := TMasterViewController.Create(UITableViewStyleGrouped);
  NavigationController := TUINavigationController.Wrap
    (TUINavigationController.Alloc.initWithRootViewController
    (MasterViewController.viewController));
  //Window.setRootViewController(MasterViewController.tableViewController);
  Window.setRootViewController(NavigationController);
  Window.makeKeyAndVisible;
  Result := True
end;

procedure TListApplicationDelegate.applicationWillTerminate(
  const Sender: UIApplication);
begin
  MasterViewController.viewController.release;
  MasterViewController := nil;
  NavigationController.release;
  Window.release;
  inherited;
end;

initialization
  ApplicationDelegateClass := TListApplicationDelegate
end.
