unit ListAppCocoa.DetailViewController;

interface

uses
  Delphi.Platform.iOS,
  iOSapi.UIKit;

type
  DetailViewController = interface(UIViewController)
    ['{26836534-DBAF-498C-9EFA-69D378E3FAD9}']
    procedure loadView; cdecl;
    procedure viewDidLoad; cdecl;
    procedure viewDidDisappear(animated: Boolean); cdecl;
  end;

  TDetailViewController = class(TBaseUIViewController<DetailViewController>)
  private
    FCellSection,
    FCellRow: Integer;
    FLabel: UILabel;
  public
    constructor Create(Section, Row: Integer);
    destructor Destroy; override;
    procedure loadView; cdecl;
    procedure viewDidLoad; cdecl;
    procedure viewDidDisappear(animated: Boolean); cdecl;
  end;

implementation

uses
  System.SysUtils,
  iOSapi.Foundation,
  iOSapi.CoreGraphics,
  iOSapi.Utils;

{ TDetailViewController }

constructor TDetailViewController.Create(Section, Row: Integer);
var
  V: Pointer;
begin
  inherited Create;
  V := UIViewController(Super).init;
  if GetObjectID <> V then
    UpdateObjectID(V);

  FCellSection := Section;
  FCellRow := Row;
end;

destructor TDetailViewController.Destroy;
begin
  NSLog(PNSStr('TDetailViewController.Destroy'));
  inherited;
end;

procedure TDetailViewController.loadView;
begin
  //allocate the view
  //view := UIView.alloc.init;
  //If using a custom init*** do like this
  //view := TUIView.Wrap(TUIView.Alloc.init);
  //But for regular init, do like this
  view := TUIView.Create;

  // Set the view's background color
  //view.backgroundColor := UIColor.whiteColor;
  view.setBackgroundColor(TUIColor.Wrap(TUIColor.OCClass.whiteColor));
end;

procedure TDetailViewController.viewDidLoad;
var
  frame: CGRect;
begin
  //Call inherited UIViewController method
  UIViewController(Super).viewDidLoad;

  viewController.setTitle(NSSTR(Format('Cell %d-%d', [FCellSection, FCellRow])));
  frame.origin.x := 100;
  frame.origin.y := 170;
  frame.size.width := 100;
  frame.size.height := 50;
  //allocate the label
  FLabel := TUILabel.Wrap(TUILabel.Alloc.initWithFrame(frame));

  //set the label's text
  FLabel.setText(viewController.title);

  //add the label to the view
  view.addSubview(FLabel);
end;

procedure TDetailViewController.viewDidDisappear(animated: Boolean);
begin
  //Call inherited UIViewController method
  UIViewController(Super).viewDidDisappear(animated);

  viewController.release;
  view.release;
  FLabel.release;
end;

end.
