unit ListAppCocoa.MasterViewController;

interface

uses
  Macapi.ObjectiveC,
  Delphi.Platform.iOS,
  iOSapi.CocoaTypes,
  iOSapi.Foundation,
  iOSapi.UIKit,
  ListAppCocoa.DetailViewController;

type
{$IF CompilerVersion = 25}
  //QC115789
  //XE4's iOSapi.CocoaTypes incorrectly defines NSInteger as Integer
  NSInteger = NativeInt;
{$ENDIF}
  PUITableView = Pointer;
  PUITableViewCell = Pointer;
  PNSString = Pointer;
  PNSIndexPath = Pointer;
  {$REGION 'NSIndexPath UIKit Additions'}
  //As per:
  // http://developer.apple.com/library/ios/documentation/uikit/reference/NSIndexPath_UIKitAdditions/Reference/Reference.html
  //allows us to use the handy row and section properties
  NSIndexPathClass = interface(iOSapi.Foundation.NSIndexPathClass)
  ['{A3183609-9CD5-43C1-A258-A5BB0616E199}']
  end;
  NSIndexPath = interface(iOSapi.Foundation.NSIndexPath)
  ['{7E3084AB-68AE-4911-9B1C-65D774D19A2A}']
    function row: NSInteger; cdecl;
    function section: NSInteger; cdecl;
  end;
  TNSIndexPath = class(TOCGenericImport<NSIndexPathClass, NSIndexPath>) end;
  {$ENDREGION}

  MasterViewController = interface(UITableViewController)
    ['{F78F3E98-8AA9-463E-ACE6-6131B2D197C6}']
    {$REGION 'UITableViewController methods'}
    procedure viewDidLoad; cdecl;
    procedure viewDidAppear(animated: Boolean); cdecl;
    {$ENDREGION}
    {$REGION 'UITableViewDelegate methods'}
    procedure tableView(tableView: UITableView;
      didSelectRowAtIndexPath: NSIndexPath); overload; cdecl;
    {$ENDREGION}
  end;

  UITableViewDataSource = interface(IObjectiveC)
    ['{7125C7B2-890F-4DA0-A20A-03EE1A8D8384}']
    function numberOfSectionsInTableView(tableView: UITableView): NSInteger; cdecl;
    //function sectionIndexTitlesForTableView(tableView: UITableView): NSArray; cdecl;
    //function tableView(tableView: UITableView; canEditRowAtIndexPath: NSIndexPath): Boolean; cdecl;
    //function tableView(tableView: UITableView; canMoveRowAtIndexPath: NSIndexPath): Boolean; cdecl;
    [MethodName('tableView:cellForRowAtIndexPath:')]
    function cellForRowAtIndexPath(tableView: UITableView; indexPath: NSIndexPath): UITableViewCell; cdecl;
    //procedure tableView(tableView: UITableView; commitEditingStyle: UITableViewCellEditingStyle; forRowAtIndexPath: NSIndexPath); cdecl;
    //procedure tableView(tableView: UITableView; moveRowAtIndexPath: NSIndexPath; toIndexPath: NSIndexPath); cdecl;
    [MethodName('tableView:numberOfRowsInSection:')]
    function numberOfRowsInSection(tableView: UITableView; section: NSInteger): NSInteger; cdecl;
    //function tableView(tableView: UITableView; sectionForSectionIndexTitle: NSString; atIndex: NSInteger): NSInteger; cdecl;
    //function tableView(tableView: UITableView; titleForFooterInSection: NSInteger): NSString; cdecl;
    [MethodName('tableView:titleForHeaderInSection:')]
    function titleForHeaderInSection(tableView: UITableView; section: NSInteger): NSString; cdecl; overload;
  end;


  TMasterViewController = class(
    TBaseUITableViewController<MasterViewController>, UITableViewDataSource)
  private
    //Instance variables to keep the Delphi controller objects alive
    detailController: TDetailViewController;
  public
    constructor Create(style: UITableViewStyle);
    {$REGION 'UITableViewController methods'}
    procedure viewDidLoad; cdecl;
    procedure viewDidAppear(animated: Boolean); cdecl;
    {$ENDREGION}
    {$REGION 'UITableViewDataSource methods'}
    function numberOfSectionsInTableView(tableView: UITableView): NSInteger; cdecl;
    [MethodName('tableView:numberOfRowsInSection:')]
    function numberOfRowsInSection(tableView: UITableView;
      section: NSInteger): NSInteger; cdecl;
    [MethodName('tableView:titleForHeaderInSection:')]
    function titleForHeaderInSection(tableView: UITableView;
      section: NSInteger): NSString; cdecl;
    [MethodName('tableView:cellForRowAtIndexPath:')]
    function cellForRowAtIndexPath(tableView: UITableView;
      indexPath: NSIndexPath): UITableViewCell; cdecl;
    {$ENDREGION}
    {$REGION 'UITableViewDelegate methods'}
    procedure tableView(tableView: UITableView;
      didSelectRowAtIndexPath: NSIndexPath); cdecl;
    {$ENDREGION}
  end;

implementation

uses
  System.SysUtils,
  iOSapi.CoreGraphics,
  iOSapi.Utils,
  ListAppCocoa.AppDelegate;

{ TMasterViewController }

constructor TMasterViewController.Create(style: UITableViewStyle);
var
  V: Pointer;
begin
  inherited Create;
  V := UITableViewController(Super).initWithStyle(style);
  if GetObjectID <> V then
    UpdateObjectID(V);

  // Custom initialization
  //viewController.setTitle(NSSTR('Delphi for Cocoa'))
end;

{$REGION 'UITableViewController methods'}
procedure TMasterViewController.viewDidAppear(animated: Boolean);
begin
  //Call inherited UIViewController method
  UITableViewController(Super).viewDidAppear(animated);
  //If we are reappearing from  secondary page, let's nil out that secondary page
  detailController := nil;
end;

procedure TMasterViewController.viewDidLoad;
begin
  //Call inherited UIViewController method
  UITableViewController(Super).viewDidLoad;
  //Additional customisation
  viewController.setTitle(NSSTR('Delphi for Cocoa'))
end;
{$ENDREGION}

{$REGION 'UITableViewDataSource methods'}
function TMasterViewController.numberOfSectionsInTableView(
  tableView: UITableView): NSInteger;
begin
  Result := 5
end;

function TMasterViewController.numberOfRowsInSection(tableView: UITableView;
  section: NSInteger): NSInteger;
begin
  Result := 2
end;

function TMasterViewController.cellForRowAtIndexPath(tableView: UITableView;
  indexPath: NSIndexPath): UITableViewCell;
{$IFNDEF WRAP_CHECKS_FOR_NIL_NOW}
var
  TableViewCell: Pointer;
{$ENDIF}
const
  CellIdentifier = 'Cell';
begin
  //Try and get an existing cell of the right kind
{$IFDEF WRAP_CHECKS_FOR_NIL_NOW}
  Result := TUITableViewCell.Wrap(
    tableView.dequeueReusableCellWithIdentifier(NSSTR(CellIdentifier)));
{$ELSE}
  Result := nil;
  TableViewCell := tableView.dequeueReusableCellWithIdentifier(NSSTR(CellIdentifier));
  if Assigned(TableViewCell) then
    Result := TUITableViewCell.Wrap(TableViewCell);
{$ENDIF}
  if Result = nil then
  begin
    //Create a new cell
    Result := TUITableViewCell.Wrap(
      TUITableViewCell.Alloc.initWithStyle(
        UITableViewCellStyleDefault, NSSTR(CellIdentifier)));
  end;
  // Configure the cell...
  Result.textLabel.setText(NSSTR(
    Format('Cell %d in section %d', [indexPath.row, indexPath.section])));
end;

function TMasterViewController.titleForHeaderInSection(tableView: UITableView;
  section: NSInteger): NSString;
begin
  Result := NSStr(Format('Section %d', [section]))
end;
{$ENDREGION}

{$REGION 'UITableViewDelegate methods'}
procedure TMasterViewController.tableView(tableView: UITableView;
  didSelectRowAtIndexPath: NSIndexPath);
var
  s: String;
  indexPath: NSIndexPath;
begin
  //NSLog(PNSSTR('TMasterViewController.tableView'));
  indexPath := didSelectRowAtIndexPath;
  s := Format('You pressed cell %d in section %d', [indexPath.row, indexPath.section]);
  Alert('Info', s);
  detailController := TDetailViewController.Create(indexPath.section, indexPath.row);
  NSLog(PNSStr('Launching detail'));
  tableViewController.navigationController.pushViewController(detailController.viewController, true);
end;
{$ENDREGION}

end.
