unit FMX.Utils;

interface

uses
  System.Sensors, FMX.Forms;

type
  TCoord2DSpan = record
    LatitudeDelta,
    LongitudeDelta: Double;
    constructor Create(const LatDelta, LongDelta : Double);
  end;

  TCoord2DRegion = record
    Center: TLocationCoord2D;
    Span: TCoord2DSpan;
    constructor Create(const LatitudeCenter, LongitudeCenter,
      LatDelta, LongDelta: Double); overload;
    constructor Create(const CenterCoord: TLocationCoord2D;
      const CoordSpan: TCoord2DSpan); overload;
  end;

function IsCoordinateValid(coord: TLocationCoord2D): Boolean;

///	<summary>
///	  Simple wrapper for the iOS NSLog() call. This takes a regular string,
///	  morphs it into an iOS string and passes it along to NSLog.
///	</summary>
///	<param name="AStr">
///	  Input string to log
///	</param>
procedure Log(const AStr: String); overload;
procedure Log(const AStr: String; const Args: array of const); overload;

procedure SetNetworkActivityIndicatorVisible(Value: Boolean);

{$IFDEF USING_FMX}
procedure TidyAwayPlatformUI(Form: TCommonCustomForm);
{$ENDIF}

implementation

uses
{$IFDEF IOS}
  iOSapi.Utils, iOSapi.Foundation, iOSapi.CoreLocation,
{$IF CompilerVersion > 25}
  FMX.Helpers.iOS,
{$ENDIF}
{$ENDIF}
  System.SysUtils;

function IsCoordinateValid(coord: TLocationCoord2D): Boolean;
begin
{$IFDEF IOS}
  Result := CLLocationCoordinate2DIsValid(ConvCoord2CLLocationCoord(coord))
{$ELSE}
  Result := False;
  {$MESSAGE WARN 'Only currently implemented for iOS'}
{$ENDIF}
end;

procedure Log(const AStr: String);
begin
{$IFDEF IOS}
  NSLog(PNSStr(AStr));
{$ELSE}
  {$MESSAGE WARN 'Only currently implemented for iOS'}
{$ENDIF}
end;

procedure Log(const AStr: String; const Args: array of const);
begin
  Log(Format(AStr, Args))
end;

procedure SetNetworkActivityIndicatorVisible(Value: Boolean);
begin
{$IFDEF IOS}
  SharedApplication.setNetworkActivityIndicatorVisible(Value);
{$ELSE}
  {$MESSAGE WARN 'Only currently implemented for iOS'}
{$ENDIF}
end;

{$IFDEF USING_FMX}
procedure TidyAwayPlatformUI(Form: TCommonCustomForm);
begin
{$IFDEF IOS}
  TidyAwayIOSView(Form.Handle);
{$ENDIF}
end;
{$ENDIF}

{ TCoord2DSpan }

constructor TCoord2DSpan.Create(const LatDelta, LongDelta: Double);
begin
  LatitudeDelta := LatDelta;
  LongitudeDelta := LongDelta;
end;

{ TCoord2DRegion }

constructor TCoord2DRegion.Create(const LatitudeCenter, LongitudeCenter,
  LatDelta, LongDelta: Double);
begin
  Center := TLocationCoord2D.Create(LatitudeCenter, LongitudeCenter);
  Span := TCoord2DSpan.Create(LatDelta, LongDelta);
end;

constructor TCoord2DRegion.Create(const CenterCoord: TLocationCoord2D;
  const CoordSpan: TCoord2DSpan);
begin
  Center := CenterCoord;
  Span := CoordSpan
end;

end.
