unit iOSapi.MapKit;

interface

uses
  Macapi.ObjectiveC, iOSapi.CocoaTypes,
  iOSapi.Foundation, iOSapi.UIKit, iOSapi.CoreLocation;

const
  //These are the enum values from MKMapType
  MKMapTypeStandard = 0;
  MKMapTypeSatellite = 1;
  MKMapTypeHybrid = 2;

type
  MKMapView = interface;
  MKMapViewDelegate = interface;
  MKUserLocation = interface;
  MKMapType = NSUInteger;

  MKCoordinateSpan = record
    latitudeDelta,
    longitudeDelta: CLLocationDegrees;
  end;

  MKCoordinateRegion = record
    center: CLLocationCoordinate2D;
    span: MKCoordinateSpan;
  end;

{$REGION 'Unused currently'}
  MKAnnotationClass = interface(NSObjectClass)
    ['{4EE650BD-8936-4FB2-B9CB-6EFB49A223EE}']
  end;
  MKAnnotation = interface(NSObject)
    function coordinate: CLLocationCoordinate2D; cdecl;
    function title: NSString; cdecl;
    function subtitle: NSString; cdecl;
  end;
  TMKAnnotation = class(TOCGenericImport<MKAnnotationClass, MKAnnotation>) end;

  MKUserLocationClass = interface(MKAnnotationClass)
    ['{DB21B0D9-9364-4CB9-ADED-63FF60666EEF}']
  end;
  MKUserLocation = interface(MKAnnotation)
    ['{30849CD0-E8D7-4E25-8213-38A7B698D0D2}']
    function heading: CLHeading; cdecl;
    function location: CLLocation; cdecl;
    function isUpdating: Boolean; cdecl;
    property updating: Boolean read isUpdating;
    //function title: NSString; cdecl; //already in MKAnnotation
    procedure setTitle(title: NSString); cdecl;
    //function subtitle: NSString; cdecl; //already in MKAnnotation
    procedure setSubtitle(subtitle: NSString); cdecl;
  end;
  TMKUserLocation = class(TOCGenericImport<MKUserLocationClass, MKUserLocation>) end;
{$ENDREGION}

  MKMapViewClass = interface(UIViewClass)
    ['{F2BE3B86-EDBF-4596-8509-C542966C76E1}']
  end;
  MKMapView = interface(UIView)
    ['{EABBE53C-94FA-482D-A0A3-6B18BFD0E7F6}']
    //TODO: Add declarations for the many other methods in MKMapView
    function delegate: Pointer; cdecl;
    procedure setDelegate(delegate: Pointer); cdecl;
    function mapType: MKMapType; cdecl;
    procedure setMapType(mapType: MKMapType); cdecl;
    //TODO: attend to the bridging present in original declararion:
    //Type is id < MKAnnotation >
    procedure selectAnnotation(annotation: MKAnnotation; animated: Boolean); cdecl;
    function showsUserLocation: Boolean; cdecl;
    procedure setCenterCoordinate(coordinate: CLLocationCoordinate2D; animated: Boolean); cdecl;
    procedure setRegion(region: MKCoordinateRegion; animated: Boolean); cdecl;
    procedure setShowsUserLocation(showsUserLocation: Boolean); cdecl;
    function userLocation: MKUserLocation; cdecl;
  end;
  TMKMapView = class(TOCGenericImport<MKMapViewClass, MKMapView>) end;

  MKMapViewDelegate = interface(IObjectiveC)
    ['{C0E50CBC-4A3C-4F6C-B158-A86A0F48E51E}']
    //TODO: Add declarations for the many other delegate methods in MKMapViewDelegate
    procedure mapViewWillStartLoadingMap(mapView: MKMapView); cdecl;
    procedure mapViewDidFinishLoadingMap(mapView: MKMapView); cdecl;
    procedure mapViewDidFailLoadingMap(mapView: MKMapView; withError: NSError); cdecl;
  end;

implementation

{$IF defined(IOS) and NOT defined(CPUARM)}
uses
  Posix.Dlfcn;

var
  MapKitModule: THandle;
{$ENDIF IOS}

//On my machine the iOS frameworks are found inside the Xcode package:
// Contents/Developer/Platforms/iPhoneSimulator.platform/Developer/SDKs/iPhoneSimulator6.1.sdk
// Contents/Developer/Platforms/iPhoneOS.platform/Developer/SDKs/iPhoneOS6.1.sdk

const
  MapKitFwk: string = '/System/Library/Frameworks/MapKit.framework/MapKit';

const
  libMapKit = '/System/Library/Frameworks/MapKit.framework/MapKit';

{$IF defined(IOS) and NOT defined(CPUARM)}
initialization
  MapKitModule := dlopen(MarshaledAString(libMapKit), RTLD_LAZY);

finalization
  dlclose(MapKitModule);
{$ENDIF IOS}
end.
