unit GPSFormU;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  System.Sensors,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Dialogs, FMX.StdCtrls, FMX.MapView,
  FMX.Sensors;

type
  TGPSForm = class(TForm)
    Header: TToolBar;
    HeaderLabel: TLabel;
    NavigateBackButton: TSpeedButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    MagHeadingLabel: TLabel;
    TrueHeadingLabel: TLabel;
    SpeedLabel: TLabel;
    CourseLabel: TLabel;
    AltitudeLabel: TLabel;
    LongitudeLabel: TLabel;
    LatitudeLabel: TLabel;
    LocationSensor: TLocationSensor;
    HeadingTimer: TTimer;
    MapPanel: TPanel;
    procedure NavigateBackButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure LocationSensorLocationChanged(Sender: TObject; const OldLocation,
      NewLocation: TLocationCoord2D);
    procedure FormDestroy(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure HeadingTimerTimer(Sender: TObject);
  private
    { Private declarations }
    OldMagHeading: Double;
    OldTrueHeading: Double;
    MapView: TMapView;
    procedure MapViewWillStartLoadingMap(ASender: TObject);
    procedure MapViewDidFinishLoadingMap(ASender: TObject);
    procedure MapViewDidFailLoadingMapWithError(ASender: TObject; const ErrorMsg: string);
  public
    { Public declarations }
  end;

var
  GPSForm: TGPSForm;

implementation

uses
  System.Math,
  FMX.Utils;

{$R *.fmx}

const
  StatusBarHeight = 20;
//  NavBarHghtPortrait = 44;
//  NavBarHghtLandscape = 32;

procedure TGPSForm.FormCreate(Sender: TObject);
begin
  LocationSensor.Accuracy := 0;
  LocationSensor.Distance := 5;
  OldTrueHeading := -1;
  OldMagHeading := -1;
  LocationSensor.Active := True;
  MapView := TMapView.Create(nil);
  MapView.Align := TAlignLayout.alClient;
  MapView.MapType := mtHybrid;
  MapView.SetUserLocationText('You are here', 'YA RLY!');
  MapView.ShowsUserLocation := True;
  MapView.OnWillStartLoadingMap := MapViewWillStartLoadingMap;
  MapView.OnDidFinishLoadingMap := MapViewDidFinishLoadingMap;
  MapView.OnDidFailLoadingMapWithError := MapViewDidFailLoadingMapWithError;
  MapView.Parent := MapPanel;
end;

procedure TGPSForm.FormDestroy(Sender: TObject);
begin
  SetNetworkActivityIndicatorVisible(False);
  LocationSensor.Active := False;
  LocationSensor := nil;
  TidyAwayPlatformUI(Self);
end;

procedure TGPSForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := TCloseAction.caFree
end;

procedure TGPSForm.HeadingTimerTimer(Sender: TObject);
const
  Epsilon = 0.01;
begin
  if LocationSensor.Sensor.TrueHeading >= 0 then
  begin
    if not SameValue(OldMagHeading, LocationSensor.Sensor.MagneticHeading, Epsilon) then
      MagHeadingLabel.Text := Format('%.1f',
        [LocationSensor.Sensor.MagneticHeading]);
    if not SameValue(OldTrueHeading, LocationSensor.Sensor.TrueHeading, Epsilon) then
      TrueHeadingLabel.Text := Format('%.1f',
        [LocationSensor.Sensor.TrueHeading]);
  end;
end;

procedure TGPSForm.LocationSensorLocationChanged(Sender: TObject;
  const OldLocation, NewLocation: TLocationCoord2D);
const
  latitudeDelta = 0.002; //no. of degrees to show in the map
  longitudeDelta = latitudeDelta;
var
  coord: TLocationCoord2D;
  coordSpan: TCoord2DSpan;
  coordRegion: TCoord2DRegion;
begin
  Log(Format('(%.8f,%.8f)', [NewLocation.Latitude, NewLocation.Longitude]));
  if LocationSensor.Accuracy >= 0 then
  begin
    LatitudeLabel.Text := Format('%.8f  %.0f m',
      [NewLocation.Latitude, LocationSensor.Sensor.ErrorRadius]);
	  LongitudeLabel.Text := Format('%.8f  %.0f m',
      [NewLocation.Longitude, LocationSensor.Sensor.ErrorRadius]);

    coord := TLocationCoord2D.Create(NewLocation.Latitude, NewLocation.Longitude);
    if IsCoordinateValid(coord) then
    begin
      coordSpan := TCoord2DSpan.Create(latitudeDelta, longitudeDelta);
      coordRegion := TCoord2DRegion.Create(coord, coordSpan);
      MapView.setRegion(coordRegion, False);
      //MapView.setCenterCoordinate(coord, False);
      //Invoke the callout on the user location annotation
      MapView.SetUserLocationAnnotation;
    end;
  end
  else
  begin
    LatitudeLabel.Text := 'N/A';
	  LongitudeLabel.Text := 'N/A';
  end;
  AltitudeLabel.Text := Format('%.2f m', [LocationSensor.Sensor.Altitude]);
  if LocationSensor.Sensor.TrueHeading >= 0 then
    CourseLabel.Text := Format('%.1f', [LocationSensor.Sensor.TrueHeading])
  else
    CourseLabel.Text := 'N/A';
  SpeedLabel.Text := Format('%.1f m/s', [LocationSensor.Sensor.Speed]);
end;

procedure TGPSForm.MapViewDidFailLoadingMapWithError(ASender: TObject;
  const ErrorMsg: string);
begin
  SetNetworkActivityIndicatorVisible(True);
  ShowMessage('Map failed to load:'#10#10 + ErrorMsg);
end;

procedure TGPSForm.MapViewDidFinishLoadingMap(ASender: TObject);
begin
  SetNetworkActivityIndicatorVisible(False);
end;

procedure TGPSForm.MapViewWillStartLoadingMap(ASender: TObject);
begin
  SetNetworkActivityIndicatorVisible(True);
end;

procedure TGPSForm.NavigateBackButtonClick(Sender: TObject);
begin
  Close
end;

end.
