unit MainFormU;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Dialogs, FMX.StdCtrls, FMX.ListBox,
  FMX.Layouts;

type
  TMainForm = class(TForm)
    Header: TToolBar;
    HeaderLabel: TLabel;
    PagesListBox: TListBox;
    BrowserListBoxGroupHeader: TListBoxGroupHeader;
    BrowserListBoxItem: TListBoxItem;
    GPSListBoxGroupHeader: TListBoxGroupHeader;
    GPSListBoxItem: TListBoxItem;
    procedure BrowserListBoxItemClick(Sender: TObject);
    procedure GPSListBoxItemClick(Sender: TObject);
    procedure PagesListBoxItemClick(const Sender: TCustomListBox;
      const Item: TListBoxItem);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.fmx}

uses BrowserFormU, GPSFormU;

procedure TMainForm.BrowserListBoxItemClick(Sender: TObject);
begin
  TBrowserForm.Create(Self).Show;
  PagesListBox.ItemIndex := -1;
end;

procedure TMainForm.GPSListBoxItemClick(Sender: TObject);
begin
  TGPSForm.Create(Self).Show;
  PagesListBox.ItemIndex := -1;
end;

procedure TMainForm.PagesListBoxItemClick(const Sender: TCustomListBox;
  const Item: TListBoxItem);
begin
  Log.d('Item %d clicked', [Item.Index]);
end;

end.
