unit Unit1;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs,
  FMX.Controls.Presentation, FMX.StdCtrls;

type
  TMainForm = class(TForm)
    TheButton: TButton;
    procedure TheButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

uses
  FMX.Platform;

{$R *.fmx}

procedure Log(const Msg: string; const Params: array of const); overload;
var
  LogSvc: IFMXLoggingService;
begin
	if TPlatformServices.Current.SupportsPlatformService(IFMXLoggingService, LogSvc) then
    Logsvc.Log(Msg, Params);
end;

procedure Log(const Msg: string); overload;
begin
  Log(Msg, [])
end;

procedure TMainForm.TheButtonClick(Sender: TObject);
begin
  Log('The button has been pressed');
end;

end.
