unit Macapi.Log;

interface

{$IFDEF MACOS}
procedure Log(const Msg: string);
{$ENDIF}

implementation

{$IFDEF MACOS}
uses
  Macapi.Helpers, // for StringToID
  Macapi.CoreFoundation; // for _PU

type
  PNSString = Pointer;

const
  libFoundation = '/System/Library/Frameworks/Foundation.framework/Foundation';

procedure NSLog(format: PNSString); cdecl; varargs; external libFoundation name _PU + 'NSLog';

procedure Log(const Msg: string);
begin
  NSLog(StringToID(Msg));
end;
{$ENDIF}

end.
