unit MainFormU;

interface

uses
  System.Messaging,
  System.SysUtils, System.Types, System.UITypes, System.Classes,
  System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs,
  Androidapi.JNI.GraphicsContentViewText, FMX.ListBox, FMX.Edit, FMX.StdCtrls,
  FMX.Layouts, FMX.Controls.Presentation;

type
  TMainForm = class(TForm)
    Layout: TLayout;
    TelNoButton: TButton;
    BatteryUsageButton: TButton;
    WebURLButton: TButton;
    MapURLButton: TButton;
    StreetViewURLButton: TButton;
    ContactsButton: TButton;
    SMSButton: TButton;
    EmailButton: TButton;
    BarcodeScannerButton: TButton;
    VertScrollBox: TVertScrollBox;
    procedure TelNoButtonClick(Sender: TObject);
    procedure BatteryUsageButtonClick(Sender: TObject);
    procedure BarcodeScannerButtonClick(Sender: TObject);
    procedure WebURLButtonClick(Sender: TObject);
    procedure MapURLButtonClick(Sender: TObject);
    procedure StreetViewURLButtonClick(Sender: TObject);
    procedure ContactsButtonClick(Sender: TObject);
    procedure SMSButtonClick(Sender: TObject);
    procedure EmailButtonClick(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word; var KeyChar: Char;
      Shift: TShiftState);
    procedure FormKeyDown(Sender: TObject; var Key: Word; var KeyChar: Char;
      Shift: TShiftState);
  private
  { Private declarations }
    const
    ScanRequestCode = 0;
    var
    FMessageSubscriptionID: Integer;
    FBackKeyHasBeenDetected: Boolean;
    procedure MessageResultNotificationHandler(const Sender: TObject; const M: TMessage);
    function OnActivityResult(RequestCode, ResultCode: Integer; Data: JIntent): Boolean;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

uses
  FMX.Platform.Android,
// Delphi 10.1 Berlin added new message box API
{$IF RTLVersion >= 31}
  FMX.DialogService,
{$ENDIF}
  Androidapi.Helpers,
  Androidapi.JNI.JavaTypes,
  Androidapi.JNI.App,
  //AndroidStuff, // for SendSMS
  LaunchActivities;

{$R *.fmx}
{ TMainForm }

procedure TMainForm.BatteryUsageButtonClick(Sender: TObject);
begin
  ShowBatteryUsage
end;

procedure TMainForm.WebURLButtonClick(Sender: TObject);
begin
  LaunchUrl('http://www.embarcadero.com/products/delphi')
end;

procedure TMainForm.MapURLButtonClick(Sender: TObject);
begin
  LaunchUrl('geo:37.422,-122.084?z=17')
end;

procedure TMainForm.StreetViewURLButtonClick(Sender: TObject);
begin
  LaunchUrl('google.streetview:cbll=37.422044,-122.083849&cbp=12,7.59,,0,-34.22&mz=21')
end;

procedure TMainForm.ContactsButtonClick(Sender: TObject);
begin
  LaunchUrl('content://contacts/people')
end;

procedure TMainForm.TelNoButtonClick(Sender: TObject);
begin
  LaunchUrl('tel:123456789')
end;

procedure TMainForm.SMSButtonClick(Sender: TObject);
begin
  // SendSMS('123456789', 'O HAI!')
  CreateSMS('123456789', 'O HAI!')
end;

procedure TMainForm.EmailButtonClick(Sender: TObject);
begin
  CreateEmail(['foo@bar.com'], 'Important Info', 'O HAI!')
end;

procedure TMainForm.BarcodeScannerButtonClick(Sender: TObject);
begin
  FMessageSubscriptionID := TMessageManager.DefaultManager.SubscribeToMessage(
    TMessageResultNotification, MessageResultNotificationHandler);
  LaunchQRScanner(ScanRequestCode);
end;

procedure TMainForm.MessageResultNotificationHandler(const Sender: TObject; const M: TMessage);
begin
  if M is TMessageResultNotification then
    OnActivityResult(TMessageResultNotification(M).RequestCode, TMessageResultNotification(M).ResultCode,
      TMessageResultNotification(M).Value);
end;

function TMainForm.OnActivityResult(RequestCode, ResultCode: Integer; Data: JIntent): Boolean;
var
  ScanContent, ScanFormat: string;
  Msg: string;
begin
  Result := False;

  TMessageManager.DefaultManager.Unsubscribe(TMessageResultNotification, FMessageSubscriptionID);
  FMessageSubscriptionID := 0;

  // For more info see https://github.com/zxing/zxing/wiki/Scanning-Via-Intent
  if RequestCode = ScanRequestCode then
  begin
    if ResultCode = TJActivity.JavaClass.RESULT_OK then
    begin
      if Assigned(Data) then
      begin
        ScanContent := JStringToString(Data.getStringExtra(StringToJString('SCAN_RESULT')));
        ScanFormat := JStringToString(Data.getStringExtra(StringToJString('SCAN_RESULT_FORMAT')));
        Msg := Format('Found %s format barcode:'#10'%s', [ScanFormat, ScanContent]);
{$IF RTLVersion >= 31}
        TDialogService.MessageDialog(Msg, TMsgDlgType.mtInformation, [TMsgDlgBtn.mbOk], TMsgDlgBtn.mbOk, 0, nil);
{$ELSE}
        MessageDlg(Msg, TMsgDlgType.mtInformation, [TMsgDlgBtn.mbOk], 0, TMsgDlgBtn.mbOk, nil);
{$ENDIF}
      end;
    end
    else if ResultCode = TJActivity.JavaClass.RESULT_CANCELED then
    begin
      ShowMessage('You cancelled the scan');
    end;
    Result := True;
  end;
end;

procedure TMainForm.FormKeyDown(Sender: TObject; var Key: Word;
  var KeyChar: Char; Shift: TShiftState);
begin
  if Key = vkHardwareBack then
    FBackKeyHasBeenDetected := True;
end;

procedure TMainForm.FormKeyUp(Sender: TObject; var Key: Word; var KeyChar: Char;
  Shift: TShiftState);
begin
  if (Key = vkHardwareBack) and not FBackKeyHasBeenDetected then
  begin
    // Prolly came from a launched activity, like ZXing
    // If you press Back in there, the key down is picked up, but the
    // key up is left floating and Delphi picks it up. Without this,
    // this activity (Delphi app) would also then close....
    Key := 0;
  end
  else
    FBackKeyHasBeenDetected := False;
end;

end.
