unit MainFormU;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs, FMX.ScrollBox,
  FMX.Memo, FMX.StdCtrls, FMX.Controls.Presentation, FMX.Edit;

type
  TMainForm = class(TForm)
    Edit1: TEdit;
    Button1: TButton;
    Memo1: TMemo;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

uses
  SerialiseU,
  MiscU,
  Androidapi.Helpers,
  Androidapi.JNIBridge,
  Androidapi.Jni,
  Androidapi.JNI.JavaTypes;

{$R *.fmx}

procedure TMainForm.Button1Click(Sender: TObject);
var
  S, S2: String;
  JS, JS2: JString;
  O: JObject;
  JavaBytes, JavaBytes2: TJavaArray<Byte>;
  BytesLen: Integer;
  Bytes: PByte;
begin
  // Get some Java object. In this case it is a Java java.lang.String object
  // http://d.android.com/reference/java/lang/String.html
  S := Edit1.Text;
  JS := StringToJString(S);

  // Serialise the string into a byte array
  JavaBytes := TSerialiser.Serialise(JS);

  // Show the byte array on-screen
  Memo1.Lines.Clear;
  Memo1.Lines.Add(JavaBytesToString(JavaBytes));
  Memo1.Lines.Add(JavaBytesToText(JavaBytes));

  // Turn Java byte array into Delphi memory block
  BytesLen := JavaBytes.Length;
  Bytes := JavaBytesToBytes(JavaBytes);
  try

    // Change the Delphi memory block into another Java byte array
    JavaBytes2 := BytesToJavaBytes(Bytes, BytesLen);

    // Now de-serialise that byte array back to an object
    O := TSerialiser.Deserialise(JavaBytes2);

    // Prove that the correct object type has been de-serialised
    Memo1.Lines.Add(
      Format('Deserialised a %s object',
             [JStringToString(O.getClass.getCanonicalName)]));

    // Cast the generic object back to a Java string
    JS2 := TJString.Wrap(O);

    // Get a Delphi string out
    S2 := JStringToString(JS2);

    // Put the extracted string back on the UI so we can prove it all worked
    Edit1.Text := S2;
  finally
    FreeMem(Bytes);
  end;
end;

end.
