unit Androidapi.Misc;

interface

{$REGION 'More stuff'}
function HasPermission(const Permission: string): Boolean;
{$ENDREGION}
procedure Vibrate(DurationMS: Int64);

implementation

uses
  System.SysUtils,
  Androidapi.Helpers,
  Androidapi.JNIBridge,
  Androidapi.JNI.OS,
  Androidapi.JNI.JavaTypes,
  Androidapi.JNI.GraphicsContentViewText;

{$REGION 'More stuff'}
function HasPermission(const Permission: string): Boolean;
begin
  //Permissions listed at:
  // http://d.android.com/reference/android/Manifest.permission.html
  Result := TAndroidHelper.Context.checkCallingOrSelfPermission(
    StringToJString(Permission)) =
    TJPackageManager.JavaClass.PERMISSION_GRANTED
end;
{$ENDREGION}

procedure Vibrate(DurationMS: Int64);
var
  VibratorObj: JObject;
  Vibrator: JVibrator;
begin
  {$REGION 'More stuff'}
  if not HasPermission('android.permission.VIBRATE') then
    raise Exception.Create('App does not have the VIBRATE permission');
  {$ENDREGION}
  VibratorObj := TAndroidHelper.Context.getSystemService(
    TJContext.JavaClass.VIBRATOR_SERVICE);
  if VibratorObj = nil then
    raise Exception.Create('Cannot access Vibrator service');
  Vibrator := TJVibrator.Wrap(VibratorObj);
  if Vibrator = nil then
    raise Exception.Create('Cannot access Vibrator interface');
  Vibrator.vibrate(DurationMS);
end;

end.
