{*******************************************************}
{                                                       }
{           CodeGear Delphi Runtime Library             }
{ Copyright(c) 2014 Embarcadero Technologies, Inc.      }
{                                                       }
{*******************************************************}

unit Androidapi.JNI.TTS;

interface

uses
  Androidapi.JNIBridge,
  Androidapi.JNI.JavaTypes,
  Androidapi.JNI.Widget,
  Androidapi.JNI.GraphicsContentViewText,
  Androidapi.JNI.Util,
  Androidapi.JNI.Os,
  Androidapi.JNI.Net,
  Androidapi.JNI.App;

type
// ===== Forward declarations =====

  JSynthesisCallback = interface;//android.speech.tts.SynthesisCallback
  JSynthesisRequest = interface;//android.speech.tts.SynthesisRequest
  JTextToSpeech = interface;//android.speech.tts.TextToSpeech
  JTextToSpeech_Engine = interface;//android.speech.tts.TextToSpeech$Engine
  JTextToSpeech_EngineInfo = interface;//android.speech.tts.TextToSpeech$EngineInfo
  JTextToSpeech_OnInitListener = interface;//android.speech.tts.TextToSpeech$OnInitListener
  JTextToSpeech_OnUtteranceCompletedListener = interface;//android.speech.tts.TextToSpeech$OnUtteranceCompletedListener
  JTextToSpeechService = interface;//android.speech.tts.TextToSpeechService
  JUtteranceProgressListener = interface;//android.speech.tts.UtteranceProgressListener

// ===== Interface declarations =====

  JSynthesisCallbackClass = interface(IJavaClass)
    ['{241AE5F6-F249-4B95-8D2D-1C5B068C57D2}']
  end;

  [JavaSignature('android/speech/tts/SynthesisCallback')]
  JSynthesisCallback = interface(IJavaInstance)
    ['{22155271-C2C9-4212-B0C6-01BE152D4F43}']
    function audioAvailable(buffer: TJavaArray<Byte>; offset: Integer; length: Integer): Integer; cdecl;
    function done: Integer; cdecl;
    procedure error; cdecl;
    function getMaxBufferSize: Integer; cdecl;
    function start(sampleRateInHz: Integer; audioFormat: Integer; channelCount: Integer): Integer; cdecl;
  end;
  TJSynthesisCallback = class(TJavaGenericImport<JSynthesisCallbackClass, JSynthesisCallback>) end;

  JSynthesisRequestClass = interface(JObjectClass)
    ['{6E0AE57B-6C0D-4C9D-AFE0-91676BA059C9}']
    {class} function init(text: JString; params: JBundle): JSynthesisRequest; cdecl;
  end;

  [JavaSignature('android/speech/tts/SynthesisRequest')]
  JSynthesisRequest = interface(JObject)
    ['{1E8FE9BA-9A87-40D7-9198-89C56CE2039C}']
    function getCallerUid: Integer; cdecl;
    function getCountry: JString; cdecl;
    function getLanguage: JString; cdecl;
    function getParams: JBundle; cdecl;
    function getPitch: Integer; cdecl;
    function getSpeechRate: Integer; cdecl;
    function getText: JString; cdecl;
    function getVariant: JString; cdecl;
  end;
  TJSynthesisRequest = class(TJavaGenericImport<JSynthesisRequestClass, JSynthesisRequest>) end;

  JTextToSpeechClass = interface(JObjectClass)
    ['{BE260883-0916-456E-B84C-6B237C8382DA}']
    {class} function _GetACTION_TTS_QUEUE_PROCESSING_COMPLETED: JString;
    {class} function _GetERROR: Integer;
    {class} function _GetLANG_AVAILABLE: Integer;
    {class} function _GetLANG_COUNTRY_AVAILABLE: Integer;
    {class} function _GetLANG_COUNTRY_VAR_AVAILABLE: Integer;
    {class} function _GetLANG_MISSING_DATA: Integer;
    {class} function _GetLANG_NOT_SUPPORTED: Integer;
    {class} function _GetQUEUE_ADD: Integer;
    {class} function _GetQUEUE_FLUSH: Integer;
    {class} function _GetSUCCESS: Integer;
    {class} function init(context: JContext; listener: JTextToSpeech_OnInitListener): JTextToSpeech; cdecl; overload;
    {class} function init(context: JContext; listener: JTextToSpeech_OnInitListener; engine: JString): JTextToSpeech; cdecl; overload;
    {class} function getMaxSpeechInputLength: Integer; cdecl;
    {class} property ACTION_TTS_QUEUE_PROCESSING_COMPLETED: JString read _GetACTION_TTS_QUEUE_PROCESSING_COMPLETED;
    {class} property ERROR: Integer read _GetERROR;
    {class} property LANG_AVAILABLE: Integer read _GetLANG_AVAILABLE;
    {class} property LANG_COUNTRY_AVAILABLE: Integer read _GetLANG_COUNTRY_AVAILABLE;
    {class} property LANG_COUNTRY_VAR_AVAILABLE: Integer read _GetLANG_COUNTRY_VAR_AVAILABLE;
    {class} property LANG_MISSING_DATA: Integer read _GetLANG_MISSING_DATA;
    {class} property LANG_NOT_SUPPORTED: Integer read _GetLANG_NOT_SUPPORTED;
    {class} property QUEUE_ADD: Integer read _GetQUEUE_ADD;
    {class} property QUEUE_FLUSH: Integer read _GetQUEUE_FLUSH;
    {class} property SUCCESS: Integer read _GetSUCCESS;
  end;

  [JavaSignature('android/speech/tts/TextToSpeech')]
  JTextToSpeech = interface(JObject)
    ['{38B05C3C-B672-4FEC-849B-0CF4D89AA507}']
    function addEarcon(earcon: JString; packagename: JString; resourceId: Integer): Integer; cdecl; overload;
    function addEarcon(earcon: JString; filename: JString): Integer; cdecl; overload;
    function addSpeech(text: JString; packagename: JString; resourceId: Integer): Integer; cdecl; overload;
    function addSpeech(text: JString; filename: JString): Integer; cdecl; overload;
    function areDefaultsEnforced: Boolean; cdecl;
    function getDefaultEngine: JString; cdecl;
    function getDefaultLanguage: JLocale; cdecl;
    function getEngines: JList; cdecl;
    function getFeatures(locale: JLocale): JSet; cdecl;
    function getLanguage: JLocale; cdecl;
    function isLanguageAvailable(loc: JLocale): Integer; cdecl;
    function isSpeaking: Boolean; cdecl;
    function playEarcon(earcon: JString; queueMode: Integer; params: JHashMap): Integer; cdecl;
    function playSilence(durationInMs: Int64; queueMode: Integer; params: JHashMap): Integer; cdecl;
    function setEngineByPackageName(enginePackageName: JString): Integer; cdecl;//Deprecated
    function setLanguage(loc: JLocale): Integer; cdecl;
    function setOnUtteranceCompletedListener(listener: JTextToSpeech_OnUtteranceCompletedListener): Integer; cdecl;//Deprecated
    function setOnUtteranceProgressListener(listener: JUtteranceProgressListener): Integer; cdecl;
    function setPitch(pitch: Single): Integer; cdecl;
    function setSpeechRate(speechRate: Single): Integer; cdecl;
    procedure shutdown; cdecl;
    function speak(text: JString; queueMode: Integer; params: JHashMap): Integer; cdecl;
    function stop: Integer; cdecl;
    function synthesizeToFile(text: JString; params: JHashMap; filename: JString): Integer; cdecl;
  end;
  TJTextToSpeech = class(TJavaGenericImport<JTextToSpeechClass, JTextToSpeech>) end;

  JTextToSpeech_EngineClass = interface(JObjectClass)
    ['{75457E65-C0B1-4AF3-A166-A553887479C5}']
    {class} function _GetACTION_CHECK_TTS_DATA: JString;
    {class} function _GetACTION_GET_SAMPLE_TEXT: JString;
    {class} function _GetACTION_INSTALL_TTS_DATA: JString;
    {class} function _GetACTION_TTS_DATA_INSTALLED: JString;
    {class} function _GetCHECK_VOICE_DATA_BAD_DATA: Integer;
    {class} function _GetCHECK_VOICE_DATA_FAIL: Integer;
    {class} function _GetCHECK_VOICE_DATA_MISSING_DATA: Integer;
    {class} function _GetCHECK_VOICE_DATA_MISSING_VOLUME: Integer;
    {class} function _GetCHECK_VOICE_DATA_PASS: Integer;
    {class} function _GetDEFAULT_STREAM: Integer;
    {class} function _GetEXTRA_AVAILABLE_VOICES: JString;
    {class} function _GetEXTRA_CHECK_VOICE_DATA_FOR: JString;
    {class} function _GetEXTRA_SAMPLE_TEXT: JString;
    {class} function _GetEXTRA_TTS_DATA_INSTALLED: JString;
    {class} function _GetEXTRA_UNAVAILABLE_VOICES: JString;
    {class} function _GetEXTRA_VOICE_DATA_FILES: JString;
    {class} function _GetEXTRA_VOICE_DATA_FILES_INFO: JString;
    {class} function _GetEXTRA_VOICE_DATA_ROOT_DIRECTORY: JString;
    {class} function _GetINTENT_ACTION_TTS_SERVICE: JString;
    {class} function _GetKEY_FEATURE_EMBEDDED_SYNTHESIS: JString;
    {class} function _GetKEY_FEATURE_NETWORK_SYNTHESIS: JString;
    {class} function _GetKEY_PARAM_PAN: JString;
    {class} function _GetKEY_PARAM_STREAM: JString;
    {class} function _GetKEY_PARAM_UTTERANCE_ID: JString;
    {class} function _GetKEY_PARAM_VOLUME: JString;
    {class} function _GetSERVICE_META_DATA: JString;
    {class} function init: JTextToSpeech_Engine; cdecl;
    {class} property ACTION_CHECK_TTS_DATA: JString read _GetACTION_CHECK_TTS_DATA;
    {class} property ACTION_GET_SAMPLE_TEXT: JString read _GetACTION_GET_SAMPLE_TEXT;
    {class} property ACTION_INSTALL_TTS_DATA: JString read _GetACTION_INSTALL_TTS_DATA;
    {class} property ACTION_TTS_DATA_INSTALLED: JString read _GetACTION_TTS_DATA_INSTALLED;
    {class} property CHECK_VOICE_DATA_BAD_DATA: Integer read _GetCHECK_VOICE_DATA_BAD_DATA;
    {class} property CHECK_VOICE_DATA_FAIL: Integer read _GetCHECK_VOICE_DATA_FAIL;
    {class} property CHECK_VOICE_DATA_MISSING_DATA: Integer read _GetCHECK_VOICE_DATA_MISSING_DATA;
    {class} property CHECK_VOICE_DATA_MISSING_VOLUME: Integer read _GetCHECK_VOICE_DATA_MISSING_VOLUME;
    {class} property CHECK_VOICE_DATA_PASS: Integer read _GetCHECK_VOICE_DATA_PASS;
    {class} property DEFAULT_STREAM: Integer read _GetDEFAULT_STREAM;
    {class} property EXTRA_AVAILABLE_VOICES: JString read _GetEXTRA_AVAILABLE_VOICES;
    {class} property EXTRA_CHECK_VOICE_DATA_FOR: JString read _GetEXTRA_CHECK_VOICE_DATA_FOR;
    {class} property EXTRA_SAMPLE_TEXT: JString read _GetEXTRA_SAMPLE_TEXT;
    {class} property EXTRA_TTS_DATA_INSTALLED: JString read _GetEXTRA_TTS_DATA_INSTALLED;
    {class} property EXTRA_UNAVAILABLE_VOICES: JString read _GetEXTRA_UNAVAILABLE_VOICES;
    {class} property EXTRA_VOICE_DATA_FILES: JString read _GetEXTRA_VOICE_DATA_FILES;
    {class} property EXTRA_VOICE_DATA_FILES_INFO: JString read _GetEXTRA_VOICE_DATA_FILES_INFO;
    {class} property EXTRA_VOICE_DATA_ROOT_DIRECTORY: JString read _GetEXTRA_VOICE_DATA_ROOT_DIRECTORY;
    {class} property INTENT_ACTION_TTS_SERVICE: JString read _GetINTENT_ACTION_TTS_SERVICE;
    {class} property KEY_FEATURE_EMBEDDED_SYNTHESIS: JString read _GetKEY_FEATURE_EMBEDDED_SYNTHESIS;
    {class} property KEY_FEATURE_NETWORK_SYNTHESIS: JString read _GetKEY_FEATURE_NETWORK_SYNTHESIS;
    {class} property KEY_PARAM_PAN: JString read _GetKEY_PARAM_PAN;
    {class} property KEY_PARAM_STREAM: JString read _GetKEY_PARAM_STREAM;
    {class} property KEY_PARAM_UTTERANCE_ID: JString read _GetKEY_PARAM_UTTERANCE_ID;
    {class} property KEY_PARAM_VOLUME: JString read _GetKEY_PARAM_VOLUME;
    {class} property SERVICE_META_DATA: JString read _GetSERVICE_META_DATA;
  end;

  [JavaSignature('android/speech/tts/TextToSpeech$Engine')]
  JTextToSpeech_Engine = interface(JObject)
    ['{A876F830-EEA2-4A8E-B40D-B7AA567205EE}']
  end;
  TJTextToSpeech_Engine = class(TJavaGenericImport<JTextToSpeech_EngineClass, JTextToSpeech_Engine>) end;

  JTextToSpeech_EngineInfoClass = interface(JObjectClass)
    ['{ECA80D2D-D36F-43E4-9820-90A8F2122E29}']
    {class} function init: JTextToSpeech_EngineInfo; cdecl;
  end;

  [JavaSignature('android/speech/tts/TextToSpeech$EngineInfo')]
  JTextToSpeech_EngineInfo = interface(JObject)
    ['{931C3765-0057-4A59-93EC-93CBEE991ADD}']
    function _Geticon: Integer;
    procedure _Seticon(Value: Integer);
    function _Getlabel: JString;
    procedure _Setlabel(Value: JString);
    function _Getname: JString;
    procedure _Setname(Value: JString);
    function toString: JString; cdecl;
    property icon: Integer read _Geticon write _Seticon;
    property &label: JString read _Getlabel write _Setlabel;
    property name: JString read _Getname write _Setname;
  end;
  TJTextToSpeech_EngineInfo = class(TJavaGenericImport<JTextToSpeech_EngineInfoClass, JTextToSpeech_EngineInfo>) end;

//  JTextToSpeech_OnInitListenerClass = interface(IJavaClass)
//    ['{B01450B5-524A-4B99-95DC-9158B7B8CC15}']
//  end;
//
//  [JavaSignature('android/speech/tts/TextToSpeech$OnInitListener')]
//  JTextToSpeech_OnInitListener = interface(IJavaInstance)
//    ['{94CC537C-E958-4EA5-B613-1465AEF6014B}']
//    procedure onInit(status: Integer); cdecl;
//  end;
//  TJTextToSpeech_OnInitListener = class(TJavaGenericImport<JTextToSpeech_OnInitListenerClass, JTextToSpeech_OnInitListener>) end;
  [JavaSignature('android/speech/tts/TextToSpeech$OnInitListener')]
  JTextToSpeech_OnInitListener = interface(IJavaInstance)
    ['{94CC537C-E958-4EA5-B613-1465AEF6014B}']
    procedure onInit(status: Integer); cdecl;
  end;

//  JTextToSpeech_OnUtteranceCompletedListenerClass = interface(IJavaClass)
//    ['{83D093B7-6FB6-46FE-A08E-1B0D25BDA841}']
//  end;
//
//  [JavaSignature('android/speech/tts/TextToSpeech$OnUtteranceCompletedListener')]
//  JTextToSpeech_OnUtteranceCompletedListener = interface(IJavaInstance)
//    ['{3EA0D21E-74E4-4204-A18F-2F68FE126E18}']
//    procedure onUtteranceCompleted(utteranceId: JString); cdecl;
//  end;
//  TJTextToSpeech_OnUtteranceCompletedListener = class(TJavaGenericImport<JTextToSpeech_OnUtteranceCompletedListenerClass, JTextToSpeech_OnUtteranceCompletedListener>) end;
  [JavaSignature('android/speech/tts/TextToSpeech$OnUtteranceCompletedListener')]
  JTextToSpeech_OnUtteranceCompletedListener = interface(IJavaInstance)
    ['{3EA0D21E-74E4-4204-A18F-2F68FE126E18}']
    procedure onUtteranceCompleted(utteranceId: JString); cdecl;
  end;

  JTextToSpeechServiceClass = interface(JServiceClass)
    ['{2A7E4DA5-50FC-43AA-8ACC-98487C02147B}']
    {class} function init: JTextToSpeechService; cdecl;
  end;

  [JavaSignature('android/speech/tts/TextToSpeechService')]
  JTextToSpeechService = interface(JService)
    ['{52D88001-D8F7-4D5B-8194-CF6AEFD0C918}']
    function onBind(intent: JIntent): JIBinder; cdecl;
    procedure onCreate; cdecl;
    procedure onDestroy; cdecl;
  end;
  TJTextToSpeechService = class(TJavaGenericImport<JTextToSpeechServiceClass, JTextToSpeechService>) end;

  JUtteranceProgressListenerClass = interface(JObjectClass)
    ['{9D335A6E-78BE-4060-B3C1-6028E603073D}']
    {class} function init: JUtteranceProgressListener; cdecl;
  end;

  [JavaSignature('android/speech/tts/UtteranceProgressListener')]
  JUtteranceProgressListener = interface(JObject)
    ['{75D1A7E1-86E7-47D6-B9EC-96F0D69DC535}']
    procedure onDone(utteranceId: JString); cdecl;
    procedure onError(utteranceId: JString); cdecl;
    procedure onStart(utteranceId: JString); cdecl;
  end;
  TJUtteranceProgressListener = class(TJavaGenericImport<JUtteranceProgressListenerClass, JUtteranceProgressListener>) end;

implementation

procedure RegisterTypes;
begin
  TRegTypes.RegisterType('Androidapi.JNI.TTS.JSynthesisCallback', TypeInfo(Androidapi.JNI.TTS.JSynthesisCallback));
  TRegTypes.RegisterType('Androidapi.JNI.TTS.JSynthesisRequest', TypeInfo(Androidapi.JNI.TTS.JSynthesisRequest));
  TRegTypes.RegisterType('Androidapi.JNI.TTS.JTextToSpeech', TypeInfo(Androidapi.JNI.TTS.JTextToSpeech));
  TRegTypes.RegisterType('Androidapi.JNI.TTS.JTextToSpeech_Engine', TypeInfo(Androidapi.JNI.TTS.JTextToSpeech_Engine));
  TRegTypes.RegisterType('Androidapi.JNI.TTS.JTextToSpeech_EngineInfo', TypeInfo(Androidapi.JNI.TTS.JTextToSpeech_EngineInfo));
  TRegTypes.RegisterType('Androidapi.JNI.TTS.JTextToSpeech_OnInitListener', TypeInfo(Androidapi.JNI.TTS.JTextToSpeech_OnInitListener));
  TRegTypes.RegisterType('Androidapi.JNI.TTS.JTextToSpeech_OnUtteranceCompletedListener', TypeInfo(Androidapi.JNI.TTS.JTextToSpeech_OnUtteranceCompletedListener));
  TRegTypes.RegisterType('Androidapi.JNI.TTS.JTextToSpeechService', TypeInfo(Androidapi.JNI.TTS.JTextToSpeechService));
  TRegTypes.RegisterType('Androidapi.JNI.TTS.JUtteranceProgressListener', TypeInfo(Androidapi.JNI.TTS.JUtteranceProgressListener));
end;

initialization
  RegisterTypes;
end.


