unit TTSMainFormU;

interface

uses
  AndroidAPI.JNIBridge,
  Androidapi.JNI.Speech,
  Androidapi.JNI.JavaTypes,
  FMX.Platform,
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs, FMX.StdCtrls, FMX.Controls.Presentation, FMX.Edit;

type
  TTTSOnInitListener = class(TJavaLocal, JTextToSpeech_OnInitListener)
  private
    TTSOnUtteranceCompletedListener: JTextToSpeech_OnUtteranceCompletedListener;
  public
    // JTextToSpeech_OnInitListener
    procedure onInit(status: Integer); cdecl;
    destructor Destroy; override;
  end;

  TTTSOnUtteranceCompletedListener = class(TJavaLocal, JTextToSpeech_OnUtteranceCompletedListener)
    // JTextToSpeech_OnUtteranceCompletedListener
    procedure onUtteranceCompleted(utteranceID: JString); cdecl;
  end;

  TfrmMain = class(TForm)
    ScriptEdit: TEdit;
    SpeakButton: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SpeakButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    TTS: JTextToSpeech;
    TTSOnInitListener: JTextToSpeech_OnInitListener;
  end;

var
  frmMain: TfrmMain;

implementation

uses
  Androidapi.Helpers,
  Androidapi.JNI.App,
  FMX.Helpers.Android,
  TypInfo, System.Generics.Collections;

{$R *.fmx}

function SpeechHashMap(Key, Value: JString): JHashMap;
begin
  Result := TJHashMap.JavaClass.init;
  Result.put(Key, Value);
end;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  TTSOnInitListener := TTTSOnInitListener.Create;
{$IF RTLVersion >= 30}
  TTS := TJTextToSpeech.JavaClass.init(TAndroidHelper.Context, TTSOnInitListener);
{$ELSE}
  TTS := TJTextToSpeech.JavaClass.init(SharedActivityContext, TTSOnInitListener);
{$ENDIF}
end;

procedure TfrmMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  TTS.stop;
  TTS.shutdown;
  TTS := nil;
  TTSOnInitListener := nil;
end;

procedure TfrmMain.SpeakButtonClick(Sender: TObject);
begin
  Log.d('Speak');
  TTS.setSpeechRate(0.85);
  TTS.speak(StringToJString(ScriptEdit.Text), TJTextToSpeech.JavaClass.QUEUE_FLUSH,
    SpeechHashMap(
      TJTextToSpeech_Engine.JavaClass.KEY_PARAM_UTTERANCE_ID,
      StringToJString('GREETING')));
  SpeakButton.Enabled := False;
  Log.d('Spoken');
end;

{ TTTSOnInitListener }

destructor TTTSOnInitListener.Destroy;
begin
  Log.d('TTTSOnInitListener.Destroy');
  TTSOnUtteranceCompletedListener := nil;
  inherited;
end;

procedure TTTSOnInitListener.onInit(status: Integer);
var
  Result : Integer;
begin
  Log.d('TTS listener onInit(status = %d)', [status]);
  if status = TJTextToSpeech.JavaClass.SUCCESS then
  begin
    Log.d('TTS initialisation = SUCCESS');
    Result := frmMain.TTS.setLanguage(TJLocale.JavaClass.ENGLISH);
    TTSOnUtteranceCompletedListener := TTTSOnUtteranceCompletedListener.Create;
    frmMain.TTS.setOnUtteranceCompletedListener(TTSOnUtteranceCompletedListener);
    if (result = TJTextToSpeech.JavaClass.LANG_MISSING_DATA) or
       (result = TJTextToSpeech.JavaClass.LANG_NOT_SUPPORTED) then
      raise Exception.Create('This Language is not supported')
    else
    begin
      Log.d('Pre-speak prep');
      // Processing after Init, if any
    end;
  end
  else
  begin
    Log.d('TTS initialisation = FAIL');
    raise Exception.Create('Initialization Failed!');
  end;
end;

{ TTTSOnUtteranceCompletedListener }

procedure TTTSOnUtteranceCompletedListener.onUtteranceCompleted(utteranceID: JString);
begin
  // No need to check the utterance ID here, as we only utter one thing, 'GREETING'
  Log.d('TTS listener onUtteranceCompleted(ID = %s)', [JStringToString(utteranceID)]);
  frmMain.SpeakButton.Enabled := True;
end;

end.