unit AssertionHandlerU;

interface

implementation

uses
  SysUtils, Windows;

procedure AssertErrorHandler(const Message, Filename: string;
  LineNumber: Integer; ErrorAddr: Pointer);
var
  S: String;
begin
  S := Format('%s (%s, line %d, address $%x)',
    [Message, Filename, LineNumber, Pred(Integer(ErrorAddr))]);
  OutputDebugString(PChar(S));
end;

procedure AssertErrorNoHandler(const Message, Filename: string;
  LineNumber: Integer; ErrorAddr: Pointer);
begin
end;

initialization
  if FindCmdLineSwitch('Debug', ['/', '-'], True) then
    AssertErrorProc := @AssertErrorHandler
  else
    AssertErrorProc := @AssertErrorNoHandler
end.
 