unit MIDASAppServerRDM;

interface

uses
  Windows, Messages, SysUtils, Classes, ComServ, ComObj, VCLCom, DataBkr,
  DBClient, MIDASAppServer_TLB, StdVcl, Provider, Db, DBTables;

type
  TCustDataRDM = class(TRemoteDataModule, ICustDataRDM)
    dbDBDEMOS: TDatabase;
    tblCustomer: TTable;
    proCustomer: TDataSetProvider;
  private
    { Private declarations }
  protected
    class procedure UpdateRegistry(Register: Boolean; const ClassID, ProgID: string); override;
  public
    { Public declarations }
  end;

implementation

{$R *.DFM}

class procedure TCustDataRDM.UpdateRegistry(Register: Boolean; const ClassID, ProgID: string);
begin
  if Register then
  begin
    inherited UpdateRegistry(Register, ClassID, ProgID);
    EnableSocketTransport(ClassID);
    EnableWebTransport(ClassID);
  end else
  begin
    DisableSocketTransport(ClassID);
    DisableWebTransport(ClassID);
    inherited UpdateRegistry(Register, ClassID, ProgID);
  end;
end;

initialization
  TComponentFactory.Create(ComServer, TCustDataRDM,
    Class_CustDataRDM, ciMultiInstance, tmApartment);
end.
