unit NewPanelReg;

interface

procedure Register;

implementation

uses
  DsgnIntf, Classes, StdCtrls, Menus, NewPanel, Controls, SysUtils;

type
  TNewPanelEditor = class(TComponentEditor)
  public
    procedure Edit; override;
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
    procedure PrepareItem(Index: Integer; const AItem: TMenuItem); override;
  end;

{ TNewPanelEditor }

procedure TNewPanelEditor.Edit;
begin
  if not IsInInlined then
    ExecuteVerb(0)
end;

procedure TNewPanelEditor.ExecuteVerb(Index: Integer);
var
  Ctrl: TWinControl;
begin
  Ctrl := Component as TWinControl;
  with TButton.Create(Designer.GetRoot) do
  begin
    Name := Designer.UniqueName('Button');
    Left := Random(Ctrl.ClientWidth - Width + 1);
    Top := Random(Ctrl.ClientHeight - Height + 1);
    Caption := TimeToStr(Time);
    Parent := Ctrl;
  end
end;

function TNewPanelEditor.GetVerb(Index: Integer): string;
var
  AName: String;
begin
  AName := Component.Name;
  if AName = '' then
    AName := Format('%s component', [Component.ClassName]);
  Result := Format('New button in %s', [AName])
end;

function TNewPanelEditor.GetVerbCount: Integer;
begin
  Result := 1;
end;

procedure TNewPanelEditor.PrepareItem(Index: Integer;
  const AItem: TMenuItem);
begin
  AItem.Enabled := not IsInInlined
end;

procedure Register;
begin
  RegisterComponents('Delphi 5', [TNewPanel]);
  RegisterComponentEditor(TNewPanel, TNewPanelEditor)
end;

initialization
  Randomize
end.
