unit Win32ControlsU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, ToolWin, ComCtrls, ImgList;

type
  TForm1 = class(TForm)
    ToolBar1: TToolBar;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Open1: TMenuItem;
    Save1: TMenuItem;
    N1: TMenuItem;
    Print1: TMenuItem;
    N2: TMenuItem;
    Exit1: TMenuItem;
    ToolButton1: TToolButton;
    ListView1: TListView;
    ImageList1: TImageList;
    ToolButton2: TToolButton;
    HeaderControl1: THeaderControl;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton3: TToolButton;
    N3: TMenuItem;
    N4: TMenuItem;
    ToolButton6: TToolButton;
    procedure FormCreate(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure ToolBar1CustomDraw(Sender: TToolBar; const ARect: TRect;
      var DefaultDraw: Boolean);
    procedure ToolBar1CustomDrawButton(Sender: TToolBar;
      Button: TToolButton; State: TCustomDrawState;
      var DefaultDraw: Boolean);
    procedure ToolButton1Click(Sender: TObject);
    procedure ToolButton2Click(Sender: TObject);
    procedure HeaderControl1SectionDrag(Sender: TObject; FromSection,
      ToSection: THeaderSection; var AllowDrag: Boolean);
    procedure ToolButton3Click(Sender: TObject);
    procedure ToolButton4Click(Sender: TObject);
    procedure ListView1InfoTip(Sender: TObject; Item: TListItem;
      var InfoTip: String);
    procedure ToolButton5Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure ToolButton6Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses
  TypInfo;

procedure TForm1.FormCreate(Sender: TObject);
var
  WA: TWorkArea;
begin
  MainMenu1.Items[0].RethinkLines;

  WA := ListView1.WorkAreas.Add;
  WA.Color := clLime;
  WA.Rect := Rect(0, 0,
    ListView1.Width div 2, ListView1.Height div 2)
end;

procedure TForm1.FormResize(Sender: TObject);
var
  I: Integer;
begin
  for I := 0 to HeaderControl1.Sections.Count - 1 do
    HeaderControl1.Sections[I].Width := ClientWidth div 4 + 1;

  if ListView1.ViewStyle = vsSmallIcon then
    ListView1.Invalidate
end;

procedure TForm1.ToolBar1CustomDraw(Sender: TToolBar; const ARect: TRect;
  var DefaultDraw: Boolean);
begin
  Sender.Canvas.Brush.Color := clRed;
  Sender.Canvas.FillRect(ARect)
end;

procedure TForm1.ToolBar1CustomDrawButton(Sender: TToolBar;
  Button: TToolButton; State: TCustomDrawState; var DefaultDraw: Boolean);
begin
  Sender.Canvas.Brush.Color := clYellow;
  Sender.Canvas.FillRect(Button.BoundsRect)
end;

procedure TForm1.ToolButton1Click(Sender: TObject);
begin
  ListView1.ViewStyle := vsReport
end;

procedure TForm1.ToolButton2Click(Sender: TObject);
begin
  ListView1.ViewStyle := vsSmallIcon
end;

procedure TForm1.HeaderControl1SectionDrag(Sender: TObject; FromSection,
  ToSection: THeaderSection; var AllowDrag: Boolean);
begin
  Caption := Format(
    'Moved header section %d (%s) onto section %d (%s)',
    [FromSection.Index, FromSection.Text,
     ToSection.Index, ToSection.Text])
end;

procedure TForm1.ToolButton3Click(Sender: TObject);
begin
  ListView1.HotTrack := True
end;

procedure TForm1.ToolButton4Click(Sender: TObject);
begin
  ListView1.HoverTime := 100
end;

procedure TForm1.ListView1InfoTip(Sender: TObject; Item: TListItem;
  var InfoTip: String);
begin
  //
end;

procedure TForm1.ToolButton5Click(Sender: TObject);
begin
  ListView1.OnInfoTip := ListView1InfoTip
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
  Application.Terminate
end;

procedure TForm1.ToolButton6Click(Sender: TObject);
begin
  SetPropValue(Self, 'BorderStyle', bsSizeToolWin)
end;

end.
